/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish;

import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.ConditionFlags;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.CraftItemCondition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.JumpingJacksCondition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.ObtainItemCondition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.StandOnBlockCondition;
import dev.qixils.crowdcontrol.plugin.paper.commands.executeorperish.SuccessCondition;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;

public enum Condition {
    STAND_ON_COBBLESTONE(new StandOnBlockCondition(2, "generic", Material.COBBLESTONE, new Material[0])),
    STAND_ON_A_PLANK(new StandOnBlockCondition(2, "plank", Material.OAK_PLANKS, Material.BIRCH_PLANKS, Material.ACACIA_PLANKS, Material.CRIMSON_PLANKS, Material.JUNGLE_PLANKS, Material.WARPED_PLANKS, Material.DARK_OAK_PLANKS, Material.SPRUCE_PLANKS)),
    STAND_ON_A_STRIPPED_LOG(new StandOnBlockCondition(5, "stripped_log", Material.STRIPPED_OAK_LOG, Material.STRIPPED_BIRCH_LOG, Material.STRIPPED_ACACIA_LOG, Material.STRIPPED_JUNGLE_LOG, Material.STRIPPED_DARK_OAK_LOG, Material.STRIPPED_SPRUCE_LOG, Material.STRIPPED_CRIMSON_STEM, Material.STRIPPED_WARPED_STEM, Material.STRIPPED_OAK_WOOD, Material.STRIPPED_BIRCH_WOOD, Material.STRIPPED_ACACIA_WOOD, Material.STRIPPED_JUNGLE_WOOD, Material.STRIPPED_DARK_OAK_WOOD, Material.STRIPPED_SPRUCE_WOOD, Material.STRIPPED_CRIMSON_HYPHAE, Material.STRIPPED_WARPED_HYPHAE)),
    OBTAIN_STONE(new ObtainItemCondition(4, "generic_block", Material.STONE)),
    CRAFT_STONE_HOE(new CraftItemCondition(3, "generic", Material.STONE_HOE)),
    CRAFT_WOODEN_HOE(new CraftItemCondition(2, "generic", Material.WOODEN_HOE)),
    STAND_ON_DIRT(new StandOnBlockCondition(2, "generic", ConditionFlags.OVERWORLD, Material.DIRT, new Material[0])),
    STAND_ON_STONE(new StandOnBlockCondition(2, "generic", ConditionFlags.OVERWORLD, Material.STONE, new Material[0])),
    STAND_ON_SAND(new StandOnBlockCondition(3, "generic", ConditionFlags.OVERWORLD, Material.SAND, new Material[0])),
    STAND_ON_A_BED(new StandOnBlockCondition(4, "bed", ConditionFlags.OVERWORLD, Material.WHITE_BED, Material.ORANGE_BED, Material.MAGENTA_BED, Material.LIGHT_BLUE_BED, Material.YELLOW_BED, Material.LIME_BED, Material.PINK_BED, Material.GRAY_BED, Material.LIGHT_GRAY_BED, Material.CYAN_BED, Material.PURPLE_BED, Material.BLUE_BED, Material.BROWN_BED, Material.GREEN_BED, Material.RED_BED, Material.BLACK_BED)),
    OBTAIN_WHEAT_SEEDS(new ObtainItemCondition(2, "generic_alt", ConditionFlags.OVERWORLD, Material.WHEAT_SEEDS)),
    CRAFT_SANDSTONE(new CraftItemCondition(2, "generic_block", Material.SANDSTONE, ConditionFlags.OVERWORLD)),
    STAND_ON_FIRE(new StandOnBlockCondition(2, "generic", ConditionFlags.NETHER, Material.FIRE, new Material[0])),
    OBTAIN_NETHER_BRICK(new ObtainItemCondition(4, "generic", ConditionFlags.NETHER, Material.NETHER_BRICK)),
    OBTAIN_OBSIDIAN(new ObtainItemCondition(4, "generic_alt", ConditionFlags.NETHER, Material.OBSIDIAN)),
    CRAFT_QUARTZ(new CraftItemCondition(2, "generic", Material.QUARTZ_BLOCK, ConditionFlags.NETHER)),
    CRAFT_GOLD_INGOT(new CraftItemCondition(2, "generic", Material.GOLD_INGOT, ConditionFlags.NETHER)),
    CRAFT_GLOWSTONE(new CraftItemCondition(2, "generic_block", Material.GLOWSTONE, ConditionFlags.NETHER)),
    JUMP(new JumpingJacksCondition(49));

    @NotNull
    private static final List<SuccessCondition> CONDITIONS;
    @NotNull
    private final SuccessCondition condition;

    @NotNull
    public static @NotNull List<@NotNull SuccessCondition> items() {
        return CONDITIONS;
    }

    private Condition(SuccessCondition condition) {
        if (condition == null) {
            throw new NullPointerException("condition is marked non-null but is null");
        }
        this.condition = condition;
    }

    @NotNull
    public SuccessCondition getCondition() {
        return this.condition;
    }

    static {
        ArrayList<SuccessCondition> conditions = new ArrayList<SuccessCondition>(Condition.values().length);
        for (Condition cond : Condition.values()) {
            conditions.add(cond.getCondition());
        }
        CONDITIONS = Collections.unmodifiableList(conditions);
    }
}

