/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.bukkit;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.CommandManager;
import dev.qixils.relocated.cloud.bukkit.BukkitParserParameters;
import dev.qixils.relocated.cloud.bukkit.CloudBukkitCapabilities;
import dev.qixils.relocated.cloud.bukkit.annotation.specifier.AllowEmptySelection;
import dev.qixils.relocated.cloud.bukkit.annotation.specifier.DefaultNamespace;
import dev.qixils.relocated.cloud.bukkit.annotation.specifier.RequireExplicitNamespace;
import dev.qixils.relocated.cloud.bukkit.data.MultipleEntitySelector;
import dev.qixils.relocated.cloud.bukkit.data.MultiplePlayerSelector;
import dev.qixils.relocated.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.relocated.cloud.bukkit.parser.BlockPredicateParser;
import dev.qixils.relocated.cloud.bukkit.parser.EnchantmentParser;
import dev.qixils.relocated.cloud.bukkit.parser.ItemStackParser;
import dev.qixils.relocated.cloud.bukkit.parser.ItemStackPredicateParser;
import dev.qixils.relocated.cloud.bukkit.parser.MaterialParser;
import dev.qixils.relocated.cloud.bukkit.parser.NamespacedKeyParser;
import dev.qixils.relocated.cloud.bukkit.parser.OfflinePlayerParser;
import dev.qixils.relocated.cloud.bukkit.parser.PlayerParser;
import dev.qixils.relocated.cloud.bukkit.parser.WorldParser;
import dev.qixils.relocated.cloud.bukkit.parser.location.Location2DParser;
import dev.qixils.relocated.cloud.bukkit.parser.location.LocationParser;
import dev.qixils.relocated.cloud.bukkit.parser.selector.MultipleEntitySelectorParser;
import dev.qixils.relocated.cloud.bukkit.parser.selector.MultiplePlayerSelectorParser;
import dev.qixils.relocated.cloud.bukkit.parser.selector.SingleEntitySelectorParser;
import dev.qixils.relocated.cloud.bukkit.parser.selector.SinglePlayerSelectorParser;
import dev.qixils.relocated.cloud.parser.ParserParameters;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Method;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class BukkitParsers {
    private BukkitParsers() {
    }

    public static <C> void register(CommandManager<C> manager) {
        manager.parserRegistry().registerParser(WorldParser.worldParser()).registerParser(MaterialParser.materialParser()).registerParser(PlayerParser.playerParser()).registerParser(OfflinePlayerParser.offlinePlayerParser()).registerParser(EnchantmentParser.enchantmentParser()).registerParser(LocationParser.locationParser()).registerParser(Location2DParser.location2DParser()).registerParser(ItemStackParser.itemStackParser()).registerParser(SingleEntitySelectorParser.singleEntitySelectorParser()).registerParser(SinglePlayerSelectorParser.singlePlayerSelectorParser());
        manager.parserRegistry().registerAnnotationMapper(AllowEmptySelection.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, annotation.value()));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultipleEntitySelector.class), parserParameters -> new MultipleEntitySelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        manager.parserRegistry().registerParserSupplier(TypeToken.get(MultiplePlayerSelector.class), parserParameters -> new MultiplePlayerSelectorParser(parserParameters.get(BukkitParserParameters.ALLOW_EMPTY_SELECTOR_RESULT, true)));
        if (CraftBukkitReflection.classExists("org.bukkit.NamespacedKey")) {
            BukkitParsers.registerParserSupplierFor(manager, NamespacedKeyParser.class);
            manager.parserRegistry().registerAnnotationMapper(RequireExplicitNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.REQUIRE_EXPLICIT_NAMESPACE, true));
            manager.parserRegistry().registerAnnotationMapper(DefaultNamespace.class, (annotation, type) -> ParserParameters.single(BukkitParserParameters.DEFAULT_NAMESPACE, annotation.value()));
        }
        if (manager.hasCapability(CloudBukkitCapabilities.BRIGADIER)) {
            BukkitParsers.registerParserSupplierFor(manager, ItemStackPredicateParser.class);
            BukkitParsers.registerParserSupplierFor(manager, BlockPredicateParser.class);
        }
    }

    private static void registerParserSupplierFor(CommandManager<?> manager, @NonNull Class<?> argumentClass) {
        try {
            Method registerParserSuppliers = argumentClass.getDeclaredMethod("registerParserSupplier", CommandManager.class);
            registerParserSuppliers.setAccessible(true);
            registerParserSuppliers.invoke(null, manager);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

