/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.paper.parser;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.relocated.cloud.bukkit.parser.WorldParser;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ArgumentParser;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.suggestion.Suggestion;
import dev.qixils.relocated.cloud.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.World;

public final class KeyedWorldParser<C>
implements ArgumentParser<C, World>,
SuggestionProvider<C> {
    private final ArgumentParser<C, World> parser;

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, World> keyedWorldParser() {
        return ParserDescriptor.of(new KeyedWorldParser<C>(), World.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, World> keyedWorldComponent() {
        return CommandComponent.builder().parser(KeyedWorldParser.keyedWorldParser());
    }

    public KeyedWorldParser() {
        Class<World> keyed = CraftBukkitReflection.findClass("org.bukkit.Keyed");
        this.parser = keyed != null && keyed.isAssignableFrom(World.class) ? null : new WorldParser();
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull World> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        if (this.parser != null) {
            return this.parser.parse(commandContext, commandInput);
        }
        String input = commandInput.readString();
        NamespacedKey key = NamespacedKey.fromString((String)input);
        if (key == null) {
            return ArgumentParseResult.failure(new WorldParser.WorldParseException(input, commandContext));
        }
        World world = Bukkit.getWorld((NamespacedKey)key);
        if (world == null) {
            return ArgumentParseResult.failure(new WorldParser.WorldParseException(input, commandContext));
        }
        return ArgumentParseResult.success(world);
    }

    @Override
    public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        if (this.parser != null) {
            return this.parser.suggestionProvider().suggestionsFuture(commandContext, input);
        }
        List worlds = Bukkit.getWorlds();
        ArrayList<Suggestion> completions = new ArrayList<Suggestion>(worlds.size() * 2);
        for (World world : worlds) {
            NamespacedKey key = world.getKey();
            if (input.hasRemainingInput() && key.getNamespace().equals("minecraft")) {
                completions.add(Suggestion.suggestion(key.getKey()));
            }
            completions.add(Suggestion.suggestion(key.getNamespace() + ':' + key.getKey()));
        }
        return CompletableFuture.completedFuture(completions);
    }
}

