/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.paper.suggestion;

import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.cloud.brigadier.suggestion.TooltipSuggestion;
import dev.qixils.relocated.cloud.paper.LegacyPaperCommandManager;
import dev.qixils.relocated.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import dev.qixils.relocated.cloud.paper.suggestion.tooltips.CompletionMapper;
import dev.qixils.relocated.cloud.paper.suggestion.tooltips.CompletionMapperFactory;
import dev.qixils.relocated.cloud.suggestion.SuggestionFactory;
import dev.qixils.relocated.cloud.suggestion.Suggestions;
import dev.qixils.relocated.cloud.util.StringUtils;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;

class BrigadierAsyncCommandSuggestionListener<C>
extends AsyncCommandSuggestionListener<C> {
    private final CompletionMapperFactory completionMapperFactory = CompletionMapperFactory.detectingRelocation();
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    BrigadierAsyncCommandSuggestionListener(@NonNull LegacyPaperCommandManager<C> paperCommandManager) {
        super(paperCommandManager);
        this.suggestionFactory = paperCommandManager.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
    }

    @Override
    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        super.onTabCompletion(event);
    }

    @Override
    protected Suggestions<C, ? extends TooltipSuggestion> querySuggestions(@NonNull C commandSender, @NonNull String input) {
        return this.suggestionFactory.suggestImmediately(commandSender, input);
    }

    @Override
    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input) {
        CompletionMapper completionMapper = this.completionMapperFactory.createMapper();
        Suggestions suggestions = this.querySuggestions(commandSender, input);
        event.completions(suggestions.list().stream().map(suggestion -> {
            @Nullable String trim = StringUtils.trimBeforeLastSpace(suggestion.suggestion(), suggestions.commandInput());
            if (trim == null) {
                return null;
            }
            return suggestion.withSuggestion(trim);
        }).filter(Objects::nonNull).map(completionMapper::map).collect(Collectors.toList()));
    }
}

