/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.paper.suggestion;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.cloud.bukkit.internal.CraftBukkitReflection;
import dev.qixils.relocated.cloud.paper.LegacyPaperCommandManager;
import dev.qixils.relocated.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import dev.qixils.relocated.cloud.paper.suggestion.BrigadierAsyncCommandSuggestionListener;
import dev.qixils.relocated.cloud.paper.suggestion.SuggestionListener;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL, since="2.0.0")
public interface SuggestionListenerFactory<C> {
    public static <C> @NonNull SuggestionListenerFactory<C> create(@NonNull LegacyPaperCommandManager<C> commandManager) {
        return new SuggestionListenerFactoryImpl(commandManager);
    }

    public @NonNull SuggestionListener<C> createListener();

    public static final class SuggestionListenerFactoryImpl<C>
    implements SuggestionListenerFactory<C> {
        private final LegacyPaperCommandManager<C> commandManager;

        private SuggestionListenerFactoryImpl(@NonNull LegacyPaperCommandManager<C> commandManager) {
            this.commandManager = commandManager;
        }

        @Override
        public @NonNull SuggestionListener<C> createListener() {
            @Nullable Class<?> completionCls = CraftBukkitReflection.findClass("com.destroystokyo.paper.event.server.AsyncTabCompleteEvent$Completion");
            if (completionCls != null) {
                return new BrigadierAsyncCommandSuggestionListener<C>(this.commandManager);
            }
            return new AsyncCommandSuggestionListener<C>(this.commandManager);
        }
    }
}

