/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.parser.standard;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.NumberParseException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.parser.standard.IntegerParser;
import dev.qixils.relocated.cloud.parser.standard.NumberParser;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import dev.qixils.relocated.cloud.type.range.ByteRange;
import dev.qixils.relocated.cloud.type.range.Range;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class ByteParser<C>
extends NumberParser<C, Byte, ByteRange>
implements BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE)
    public static final byte DEFAULT_MINIMUM = -128;
    @API(status=API.Status.STABLE)
    public static final byte DEFAULT_MAXIMUM = 127;

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Byte> byteParser() {
        return ByteParser.byteParser((byte)-128, (byte)127);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Byte> byteParser(byte minValue) {
        return ParserDescriptor.of(new ByteParser<C>(minValue, 127), Byte.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull ParserDescriptor<C, Byte> byteParser(byte minValue, byte maxValue) {
        return ParserDescriptor.of(new ByteParser<C>(minValue, maxValue), Byte.class);
    }

    @API(status=API.Status.STABLE)
    public static <C> @NonNull CommandComponent.Builder<C, Byte> byteComponent() {
        return CommandComponent.builder().parser(ByteParser.byteParser());
    }

    public ByteParser(byte min, byte max) {
        super(Range.byteRange(min, max));
    }

    @Override
    public @NonNull ArgumentParseResult<Byte> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        if (!commandInput.isValidByte((ByteRange)this.range())) {
            return ArgumentParseResult.failure(new ByteParseException(commandInput.peekString(), this, commandContext));
        }
        return ArgumentParseResult.success(commandInput.readByte());
    }

    @Override
    public boolean hasMax() {
        return ((ByteRange)this.range()).maxByte() != 127;
    }

    @Override
    public boolean hasMin() {
        return ((ByteRange)this.range()).minByte() != -128;
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        return IntegerParser.getSuggestions(this.range(), input);
    }

    @API(status=API.Status.STABLE)
    public static final class ByteParseException
    extends NumberParseException {
        @API(status=API.Status.STABLE)
        public ByteParseException(@NonNull String input, @NonNull ByteParser<?> parser, @NonNull CommandContext<?> commandContext) {
            super(input, parser, commandContext);
        }

        @Override
        public @NonNull String numberType() {
            return "byte";
        }
    }
}

