/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.services;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.services.PipelineException;
import dev.qixils.relocated.cloud.services.ServiceRepository;
import dev.qixils.relocated.cloud.services.type.Service;
import io.leangen.geantyref.TypeToken;
import java.util.function.Predicate;

enum ServiceFilterHandler {
    INSTANCE;


    <Context> boolean passes(@NonNull ServiceRepository.ServiceWrapper<? extends Service<Context, ?>> service, @NonNull Context context) {
        if (!service.isDefaultImplementation()) {
            for (Predicate predicate : service.filters()) {
                try {
                    if (predicate.test(context)) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new PipelineException(String.format("Failed to evaluate filter '%s' for '%s'", TypeToken.get(predicate.getClass()).getType().getTypeName(), service), e);
                }
            }
        }
        return true;
    }
}

