/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.qixils.relocated.annotations.NotNull;
import java.util.UUID;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;

public abstract class CCEffectResponse {
    @NotNull
    protected final UUID id;
    protected final int stamp;
    @JsonProperty(value="request")
    @NotNull
    protected final UUID request;
    @NotNull
    protected final String message;
    @NotNull
    protected final ResponseStatus status;

    CCEffectResponse(@NotNull UUID id, int stamp, @NotNull UUID request, @NotNull String message, @NotNull ResponseStatus status) {
        this.id = id;
        this.request = request;
        this.stamp = stamp;
        this.message = message;
        this.status = status;
    }

    protected CCEffectResponse(@NotNull UUID requestID, @NotNull ResponseStatus status, @NotNull String message) {
        this.id = UUID.randomUUID();
        this.stamp = (int)(System.currentTimeMillis() / 1000L);
        this.request = requestID;
        this.status = status;
        this.message = message;
    }

    @JsonCreator
    CCEffectResponse create(@JsonProperty(value="id") @NotNull UUID id, @JsonProperty(value="stamp") int stamp, @JsonProperty(value="request") @NotNull UUID request, @JsonProperty(value="message") @NotNull String message, @JsonProperty(value="status") @NotNull ResponseStatus status, @JsonProperty(value="timeRemaining") int timeRemaining) {
        return status.isTimed() ? new CCTimedEffectResponse(id, stamp, request, message, status, timeRemaining) : new CCInstantEffectResponse(id, stamp, request, message, status);
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="request")
    @NotNull
    public UUID getRequestId() {
        return this.request;
    }

    @JsonProperty(value="stamp")
    public int getTimestamp() {
        return this.stamp;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    @NotNull
    public ResponseStatus getStatus() {
        return this.status;
    }
}

