/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.health;

import dev.qixils.crowdcontrol.common.ExecuteUsing;
import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

@ExecuteUsing(value=ExecuteUsing.Type.SYNC_GLOBAL)
public class DamageCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "damage";
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND;
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        int amount = request.getQuantity() * 2;
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, "health_modifier")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot damage players under the effects of health modifiers");
            }
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                double newHealth;
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                double oldHealth = player.health();
                double appliedDamage = oldHealth - (newHealth = Math.max(1.0, oldHealth - (double)amount));
                if (appliedDamage != (double)amount) continue;
                player.damage(appliedDamage);
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Players would have been killed by this command");
        }));
    }

    public DamageCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @NotNull
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }
}

