/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.packets;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.packets.PluginPacket;
import dev.qixils.crowdcontrol.common.packets.util.LanguageState;
import io.netty.buffer.ByteBuf;
import java.time.Duration;

public class SetLanguagePacketS2C
implements PluginPacket {
    public static final PluginPacket.Metadata<SetLanguagePacketS2C> METADATA = new PluginPacket.Metadata<SetLanguagePacketS2C>(Plugin.SET_LANGUAGE_KEY.asString(), SetLanguagePacketS2C::new);
    private final LanguageState state;
    private final Duration duration;

    public SetLanguagePacketS2C(ByteBuf buf) {
        this.state = LanguageState.values()[buf.readInt()];
        this.duration = Duration.ofMillis(buf.readLong());
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.state.ordinal());
        buf.writeLong(this.duration.toMillis());
    }

    @Override
    public PluginPacket.Metadata<?> metadata() {
        return METADATA;
    }

    public LanguageState state() {
        return this.state;
    }

    public Duration duration() {
        return this.duration;
    }

    public SetLanguagePacketS2C(LanguageState state, Duration duration) {
        this.state = state;
        this.duration = duration;
    }
}

