/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.packets;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.packets.PluginPacket;
import dev.qixils.crowdcontrol.common.packets.util.Utf8String;
import io.netty.buffer.ByteBuf;
import java.time.Duration;

public class ShaderPacketS2C
implements PluginPacket {
    public static final PluginPacket.Metadata<ShaderPacketS2C> METADATA = new PluginPacket.Metadata<ShaderPacketS2C>(Plugin.SHADER_KEY.asString(), ShaderPacketS2C::new);
    protected static final int SIZE = 64;
    private final String shader;
    private final Duration duration;

    public ShaderPacketS2C(ByteBuf buf) {
        this.shader = Utf8String.read(buf, 64);
        this.duration = Duration.ofMillis(buf.readLong());
    }

    @Override
    public void write(ByteBuf buf) {
        Utf8String.write(buf, this.shader, 64);
        buf.writeLong(this.duration.toMillis());
    }

    @Override
    public PluginPacket.Metadata<?> metadata() {
        return METADATA;
    }

    public String shader() {
        return this.shader;
    }

    public Duration duration() {
        return this.duration;
    }

    public ShaderPacketS2C(String shader, Duration duration) {
        this.shader = shader;
        this.duration = duration;
    }
}

