/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.crowdcontrol.common.util.KeyedTag;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.MonotonicNonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;

public class MappedKeyedTag<T>
implements Iterable<T> {
    @NotNull
    private final Map<Key, T> keyMap;
    @NotNull
    private final Function<Key, T> mapper;
    @NotNull
    private final KeyedTag tag;
    private @MonotonicNonNull Set<T> calculatedValues = null;

    public MappedKeyedTag(@NotNull KeyedTag tag, @NotNull @NotNull Function<@NotNull Key, @Nullable T> mapper) {
        this.keyMap = new HashMap<Key, T>(tag.getKeys().size());
        this.tag = tag;
        this.mapper = mapper;
    }

    private T map(@NotNull Key key) {
        return this.keyMap.computeIfAbsent(key, this.mapper);
    }

    @NotNull
    public @NotNull Set<@NotNull T> getAll() {
        if (this.calculatedValues != null) {
            return this.calculatedValues;
        }
        this.tag.getKeys().forEach(this::map);
        this.calculatedValues = Collections.unmodifiableSet(new HashSet<T>(this.keyMap.values()));
        return this.calculatedValues;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.getAll().spliterator();
    }

    @NotNull
    public T getRandom() throws IllegalStateException {
        if (this.calculatedValues == null) {
            ArrayList<Key> keys = new ArrayList<Key>(this.tag.getKeys());
            Collections.shuffle(keys, RandomUtil.RNG);
            for (Key key : keys) {
                T item = this.map(key);
                if (item == null) continue;
                return item;
            }
            throw new IllegalStateException("Could not find a valid mapped value");
        }
        if (this.calculatedValues.isEmpty()) {
            throw new IllegalStateException("Could not find a valid mapped value");
        }
        return RandomUtil.randomElementFrom(this.calculatedValues);
    }

    @Contract(value="null -> false; !null -> _")
    public boolean contains(@Nullable T item) {
        return this.getAll().contains(item);
    }

    @Contract(pure=true)
    public boolean containsKey(@NotNull Keyed item) {
        return this.tag.contains(item);
    }

    @Contract(value="null -> false; !null -> _", pure=true)
    public boolean containsKey(@Nullable Key item) {
        return this.tag.contains(item);
    }
}

