/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.util;

import dev.qixils.relocated.adventure.serializer.plain.PlainTextComponentSerializer;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.translation.Translatable;

public interface TextUtil {
    @Nullable
    public ComponentFlattener flattener();

    @NotNull
    public PlainTextComponentSerializer serializer();

    @NotNull
    default public String asPlain(@NotNull ComponentLike component) {
        return this.serializer().serialize(component.asComponent());
    }

    @NotNull
    default public String translate(@NotNull Translatable translatable) {
        return this.asPlain((ComponentLike)Component.translatable((Translatable)translatable));
    }

    @Contract(value="null -> null; !null -> !null")
    public static String titleCase(@Nullable String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replace('_', ' ');
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text.toCharArray()) {
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }

    @Contract(value="null -> null; !null -> !null")
    public static String titleCase(@Nullable Enum<?> enm) {
        if (enm == null) {
            return null;
        }
        return TextUtil.titleCase(enm.name());
    }
}

