/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.FeatureElementCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7699;
import net.minecraft.class_7923;

public class BlockCommand
extends ModdedCommand
implements FeatureElementCommand {
    private final class_2248 blockType;
    private final String effectName;
    private final Component displayName;

    public BlockCommand(ModdedCrowdControlPlugin plugin, class_2248 blockType) {
        this(plugin, blockType, "block_" + class_7923.field_41175.method_10221((Object)blockType).method_12832(), (Component)Component.translatable((String)"cc.effect.block.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure((class_2561)blockType.method_9518())}));
    }

    protected BlockCommand(ModdedCrowdControlPlugin plugin, class_2248 blockType, String effectName, Component displayName) {
        super(plugin);
        this.blockType = blockType;
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @NotNull
    public class_7699 method_45322() {
        return this.blockType.method_45322();
    }

    @Nullable
    protected Location getLocation(class_3222 player) {
        Location location = new Location((class_1297)player);
        if (!BlockFinder.isReplaceable(location)) {
            return null;
        }
        return location;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (class_3222 player : (List)playerSupplier.get()) {
                Location location = this.getLocation(player);
                if (location == null) continue;
                class_2680 currentBlock = location.block();
                class_2248 currentType = currentBlock.method_26204();
                if (!BlockFinder.isReplaceable(currentBlock) || currentType.equals(this.blockType)) continue;
                success = true;
                this.sync(() -> location.block(this.blockType.method_9564()));
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No available locations to set blocks");
        }));
    }

    public class_2248 getBlockType() {
        return this.blockType;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }
}

