/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.plugin.fabric.FeatureElementCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.List;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7699;

public interface EntityCommand<E extends class_1297>
extends FeatureElementCommand {
    @NotNull
    public class_1299<? extends E> getEntityType();

    @NotNull
    default public class_7699 method_45322() {
        return this.getEntityType().method_45322();
    }

    default public boolean isMonster() {
        return this.getEntityType().method_5891() == class_1311.field_6302;
    }

    default public boolean levelIsPeaceful(@NotNull class_3218 level) {
        return level.method_8407() == class_1267.field_5801;
    }

    default public boolean serverIsPeaceful() {
        return this.getPlugin().theGame().method_68997().stream().allMatch(this::levelIsPeaceful);
    }

    @Override
    default public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        if (!this.isMonster()) {
            return TriState.UNKNOWN;
        }
        if (!this.serverIsPeaceful()) {
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    @Nullable
    default public CCEffectResponse tryExecute(@NotNull @NotNull List<@NotNull class_3222> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        CCInstantEffectResponse error = null;
        for (class_3222 player : players) {
            class_3218 level = player.method_51469();
            if (this.isMonster() && this.levelIsPeaceful(level)) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Hostile mobs cannot be spawned while on Peaceful difficulty");
                continue;
            }
            if (this.getEntityType() == class_1299.field_6116 && level.method_29198() != null) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Ender Dragons are very sensitive cannot be spawned in or removed from The End, sorry!");
                continue;
            }
            if (!this.method_45382(player.method_51469().method_45162())) {
                error = new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Mob is not available in this version of Minecraft");
                continue;
            }
            return null;
        }
        return error;
    }
}

