/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Listener;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_3222;

public class GameModeCommand
extends ModdedCommand
implements CCTimedEffect {
    private final Duration defaultDuration;
    private final class_1934 gamemode;
    private final Component displayName;
    private final String effectName;
    private final Map<UUID, List<UUID>> activeRequests = new HashMap<UUID, List<UUID>>();
    private final String effectGroup = "gamemode";
    private final List<String> effectGroups = Collections.singletonList("gamemode");

    public GameModeCommand(ModdedCrowdControlPlugin plugin, class_1934 gamemode, long seconds) {
        super(plugin);
        this.defaultDuration = Duration.ofSeconds(seconds);
        this.gamemode = gamemode;
        this.displayName = plugin.toAdventure(gamemode.method_8383());
        this.effectName = gamemode.method_8381() + "_mode";
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Conflicting effects active");
            }
            List players = (List)playerSupplier.get();
            this.activeRequests.put(request.getRequestId(), players.stream().map(class_1297::method_5667).toList());
            this.setGameMode(players, this.gamemode, true);
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    public void onEnd(@NotNull PublicEffectPayload request, @NotNull CCPlayer source) {
        List<class_3222> players = this.plugin.toPlayerList((Collection<UUID>)this.activeRequests.remove(request.getRequestId()));
        this.setGameMode(players, class_1934.field_9215, false);
    }

    private void setGameMode(@NotNull @NotNull List<@NotNull class_3222> players, @NotNull class_1934 gamemode, boolean enabling) {
        if (players.isEmpty()) {
            return;
        }
        this.sync(() -> players.forEach(player -> {
            player.method_7336(gamemode);
            player.cc$setGameTypeEffect((class_1934)(enabling ? gamemode : null));
        }));
    }

    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    public class_1934 getGamemode() {
        return this.gamemode;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public Map<UUID, List<UUID>> getActiveRequests() {
        return this.activeRequests;
    }

    public String getEffectGroup() {
        return this.effectGroup;
    }

    @Override
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }

    public static final class Manager {
        @Listener
        public void onJoin(Join event) {
            class_3222 player = event.player();
            class_1934 gameMode = player.cc$getGameTypeEffect();
            if (gameMode == null) {
                return;
            }
            player.cc$setGameTypeEffect(null);
            player.method_7336(class_1934.field_9215);
        }
    }
}

