/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.relocated.annotations.Blocking;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class GiveItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final class_1792 item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public GiveItemCommand(ModdedCrowdControlPlugin plugin, class_1792 item) {
        super(plugin);
        this.item = item;
        this.effectName = "give_" + class_7923.field_41178.method_10221((Object)item).method_12832();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.give_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.method_7864(new class_1799((class_1935)item)))});
    }

    @Blocking
    public static void giveItemTo(class_3222 player, class_1799 itemStack) {
        class_1542 entity = player.method_5775(player.method_51469(), itemStack);
        if (entity == null) {
            throw new IllegalStateException("Could not spawn item entity");
        }
        entity.method_48349(player.method_5667());
        entity.method_6981((class_1297)player);
        entity.method_6982(0);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getItemLimit(class_7923.field_41178.method_10221((Object)this.item).method_12832());
            int amount = request.getQuantity();
            class_1799 itemStack = new class_1799((class_1935)this.item, amount);
            return this.executeLimit(request, players, playerLimit, player -> {
                this.sync(() -> GiveItemCommand.giveItemTo(player, itemStack));
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            });
        }));
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    public class_1792 getItem() {
        return this.item;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

