/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.relocated.annotations.NotNull;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ConcatenatedList<E>
extends AbstractList<E> {
    @NotNull
    private final @NotNull Iterable<? extends @NotNull List<E>> lists;

    private ConcatenatedList(@NotNull @NotNull Iterable<? extends @NotNull List<E>> lists) {
        this.lists = lists;
    }

    private static <E> List<List<E>> iterableToList(@NotNull Iterable<List<E>> listsIterable) {
        ArrayList<List<List<E>>> listsList;
        if (listsIterable instanceof Collection) {
            Collection collection = (Collection)listsIterable;
            listsList = new ArrayList(collection.size());
        } else {
            listsList = new ArrayList<List<List<E>>>();
            for (List<E> list : listsIterable) {
                listsList.add(list);
            }
        }
        return listsList;
    }

    @NotNull
    public static <E> List<E> of(@NotNull Iterable<? extends List<E>> lists) {
        return new ConcatenatedList<E>(lists);
    }

    @NotNull
    public static <E> List<E> copyOf(@NotNull Iterable<List<E>> lists) {
        ArrayList<E> items = new ArrayList<E>();
        for (List<E> list : lists) {
            items.addAll(list);
        }
        return Collections.unmodifiableList(items);
    }

    @NotNull
    public static <E> List<E> shallowCopyOf(@NotNull Iterable<List<E>> lists) {
        return ConcatenatedList.of(ConcatenatedList.iterableToList(lists));
    }

    private Stream<? extends List<E>> listStream() {
        return StreamSupport.stream(this.lists.spliterator(), false);
    }

    private List<E> createList() {
        ArrayList<E> items = new ArrayList<E>(this.size());
        for (List<E> list : this.lists) {
            items.addAll(list);
        }
        return items;
    }

    @Override
    public int size() {
        return this.listStream().mapToInt(List::size).sum();
    }

    @Override
    public boolean isEmpty() {
        return this.listStream().allMatch(List::isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.listStream().anyMatch(list -> list.contains(o));
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.createList().containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public E get(int index) {
        for (List<E> list : this.lists) {
            if (index < list.size()) {
                return list.get(index);
            }
            index -= list.size();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E set(int index, E element) {
        for (List<E> list : this.lists) {
            if (index < list.size()) {
                return list.set(index, element);
            }
            index -= list.size();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        for (List<E> list : this.lists) {
            int index = list.indexOf(o);
            if (index != -1) {
                return index + i;
            }
            i += list.size();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int lastIndex = -1;
        int searchedItems = 0;
        for (List<E> list : this.lists) {
            lastIndex = Math.max(lastIndex, searchedItems + list.lastIndexOf(o));
            searchedItems += list.size();
        }
        return lastIndex;
    }
}

