/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate.serialize;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.configurate.ConfigurationNode;
import dev.qixils.relocated.configurate.serialize.SerializationException;
import dev.qixils.relocated.configurate.serialize.TypeSerializer;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Predicate;

public abstract class ScalarSerializer<T>
implements TypeSerializer.Annotated<T> {
    private final TypeToken<T> type;

    protected ScalarSerializer(TypeToken<T> type) {
        Type boxed = GenericTypeReflector.box(type.getType());
        this.type = boxed == type.getType() ? type : TypeToken.get(boxed);
    }

    protected ScalarSerializer(Class<T> type) {
        if (type.getTypeParameters().length > 0) {
            throw new IllegalArgumentException("Provided type " + type + " has type parameters but was not provided as a TypeToken!");
        }
        this.type = TypeToken.get(type);
    }

    ScalarSerializer(Type type) {
        this.type = TypeToken.get(type);
    }

    public final TypeToken<T> type() {
        return this.type;
    }

    @Override
    public final T deserialize(Type type, ConfigurationNode node) throws SerializationException {
        return (T)TypeSerializer.Annotated.super.deserialize(type, node);
    }

    @Override
    public final T deserialize(AnnotatedType type, ConfigurationNode node) throws SerializationException {
        List<? extends ConfigurationNode> children;
        ConfigurationNode deserializeFrom = node;
        if (node.isList() && (children = node.childrenList()).size() == 1) {
            deserializeFrom = children.get(0);
        }
        if (deserializeFrom.isList() || deserializeFrom.isMap()) {
            throw new SerializationException(type, "Value must be provided as a scalar!");
        }
        @Nullable Object value = deserializeFrom.rawScalar();
        if (value == null) {
            throw new SerializationException(type, "No scalar value present");
        }
        type = GenericTypeReflector.toCanonicalBoxed(type);
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(type, value);
    }

    public final T deserialize(Object value) throws SerializationException {
        @Nullable T possible = this.cast(value);
        if (possible != null) {
            return possible;
        }
        return this.deserialize(this.type().getAnnotatedType(), value);
    }

    public T deserialize(AnnotatedType type, Object obj) throws SerializationException {
        return this.deserialize(type.getType(), obj);
    }

    public abstract T deserialize(Type var1, Object var2) throws SerializationException;

    @Override
    public final void serialize(AnnotatedType type, @Nullable T obj, ConfigurationNode node) {
        if (obj == null) {
            node.raw(null);
            return;
        }
        if (node.options().acceptsType(obj.getClass())) {
            node.raw(obj);
            return;
        }
        node.raw(this.serialize(type, obj, node.options()::acceptsType));
    }

    @Override
    public final void serialize(Type type, @Nullable T obj, ConfigurationNode node) {
        this.serialize(GenericTypeReflector.annotate(type), obj, node);
    }

    protected Object serialize(AnnotatedType type, T item, Predicate<Class<?>> typeSupported) {
        return this.serialize(item, typeSupported);
    }

    protected abstract Object serialize(T var1, Predicate<Class<?>> var2);

    private @Nullable T cast(Object value) {
        Class<?> rawType = GenericTypeReflector.erase(this.type().getType());
        if (rawType.isInstance(value)) {
            return (T)value;
        }
        return null;
    }

    public final @Nullable T tryDeserialize(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.deserialize(obj);
        }
        catch (SerializationException ex) {
            return null;
        }
    }

    public final String serializeToString(T item) {
        if (item instanceof CharSequence) {
            return item.toString();
        }
        return (String)this.serialize(GenericTypeReflector.annotate(item.getClass()), item, (Class<?> clazz) -> clazz.isAssignableFrom(String.class));
    }

    public static abstract class Annotated<V>
    extends ScalarSerializer<V> {
        protected Annotated(Class<V> type) {
            super(type);
        }

        protected Annotated(TypeToken<V> type) {
            super(type);
        }

        @Override
        public abstract V deserialize(AnnotatedType var1, Object var2) throws SerializationException;

        @Override
        public V deserialize(Type type, Object obj) throws SerializationException {
            return this.deserialize(GenericTypeReflector.annotate(type), obj);
        }

        @Override
        protected abstract Object serialize(AnnotatedType var1, V var2, Predicate<Class<?>> var3);

        @Override
        protected Object serialize(V item, Predicate<Class<?>> typeSupported) {
            return this.serialize(GenericTypeReflector.annotate(item.getClass()), item, typeSupported);
        }
    }
}

