/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.client;

import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.packets.util.LanguageState;
import dev.qixils.crowdcontrol.plugin.fabric.client.ModdedPlatformClient;
import dev.qixils.crowdcontrol.plugin.fabric.client.fabric.ClientPacketContextImpl;
import dev.qixils.crowdcontrol.plugin.fabric.packets.MovementStatusS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.RequestVersionS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetLanguageS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetShaderS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.fabric.PacketUtilImpl;
import dev.qixils.relocated.annotations.NotNull;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import jerozgen.languagereload.LanguageReload;
import jerozgen.languagereload.config.Config;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class FabricPlatformClient
extends ModdedPlatformClient
implements ClientModInitializer {
    @NotNull
    public static FabricPlatformClient get() {
        return (FabricPlatformClient)ModdedPlatformClient.get();
    }

    @Override
    public void onInitializeClient() {
        super.onInitializeClient();
        PacketUtilImpl.registerPackets();
        ClientPlayNetworking.registerGlobalReceiver(RequestVersionS2C.PACKET_ID, (payload, context) -> this.handleRequestVersion((RequestVersionS2C)payload, new ClientPacketContextImpl(context)));
        ClientPlayNetworking.registerGlobalReceiver(SetShaderS2C.PACKET_ID, (payload, context) -> this.handleSetShader((SetShaderS2C)payload, new ClientPacketContextImpl(context)));
        ClientPlayNetworking.registerGlobalReceiver(MovementStatusS2C.PACKET_ID, (payload, context) -> this.handleMovementStatus((MovementStatusS2C)payload, new ClientPacketContextImpl(context)));
        ClientPlayNetworking.registerGlobalReceiver(SetLanguageS2C.PACKET_ID, (payload, context) -> this.handleLanguage((SetLanguageS2C)payload));
    }

    @Override
    @NotNull
    public Set<ExtraFeature> getExtraFeatures() {
        Set<ExtraFeature> features = super.getExtraFeatures();
        if (FabricLoader.getInstance().isModLoaded("languagereload")) {
            features.add(ExtraFeature.LANGUAGE_RELOAD);
        }
        return features;
    }

    public void handleLanguage(SetLanguageS2C payload) {
        if (this.client == null) {
            return;
        }
        if (!this.getExtraFeatures().contains((Object)ExtraFeature.LANGUAGE_RELOAD)) {
            return;
        }
        if (LANGUAGE_STATE == payload.state()) {
            return;
        }
        LanguageState languageState = LANGUAGE_STATE = payload.state();
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RESET", "RANDOM"}, (LanguageState)languageState, n)) {
            case 0: {
                Config config = Config.getInstance();
                LanguageReload.setLanguage((String)config.previousLanguage, (LinkedList)config.previousFallbacks);
                break;
            }
            case 1: {
                Config config = Config.getInstance();
                ArrayList languages = new ArrayList(this.client.method_1526().method_4665().keySet());
                languages.remove(config.language);
                languages.removeAll(config.fallbacks);
                languages.remove("en_us");
                Collections.shuffle(languages);
                LinkedList<String> fallback = new LinkedList<String>(languages.subList(1, 6));
                fallback.add("en_us");
                LanguageReload.setLanguage((String)((String)languages.getFirst()), fallback);
                break;
            }
            default: {
                this.logger.warn("Unknown language state {}", (Object)LANGUAGE_STATE);
            }
        }
        if (LANGUAGE_STATE != LanguageState.RESET) {
            this.executor.schedule(() -> this.handleLanguage(new SetLanguageS2C(LanguageState.RESET, Duration.ZERO)), payload.duration().toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void sendToServer(@NotNull class_8710 payload) {
        if (!ClientPlayNetworking.canSend((class_8710.class_9154)payload.method_56479())) {
            return;
        }
        try {
            ClientPlayNetworking.send((class_8710)payload);
        }
        catch (UnsupportedOperationException e) {
            this.logger.debug("Server cannot receive packet {}", (Object)payload);
        }
    }
}

