/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.client;

import dev.qixils.crowdcontrol.common.HideNames;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.packets.util.LanguageState;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.client.ClientMinecraftEvents;
import dev.qixils.crowdcontrol.plugin.fabric.client.ClientPacketContext;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ExtraFeatureC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.MovementStatusS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.RequestVersionS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ResponseVersionC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetShaderS2C;
import dev.qixils.crowdcontrol.plugin.fabric.utils.ClientAdapter;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OnlyIn(value=Dist.CLIENT)
public abstract class ModdedPlatformClient {
    protected final Logger logger = LoggerFactory.getLogger("CrowdControl/Client");
    protected final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    @Nullable
    protected static ModdedPlatformClient INSTANCE = null;
    public static boolean SHADER_ACTIVE = false;
    public static LanguageState LANGUAGE_STATE = LanguageState.RESET;
    protected class_310 client = null;

    @NotNull
    public static ModdedPlatformClient get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Client instance is uninitialized. Please query `ModdedCrowdControlPlugin.CLIENT_INITIALIZED` before calling this method.");
        }
        return INSTANCE;
    }

    @NotNull
    public Set<ExtraFeature> getExtraFeatures() {
        return EnumSet.noneOf(ExtraFeature.class);
    }

    public void onInitializeClient() {
        INSTANCE = this;
        ModdedCrowdControlPlugin.CLIENT_INITIALIZED = true;
        ClientAdapter.setLocalPlayerIdSupplier(() -> this.player().map(class_1297::method_5667));
        ClientMinecraftEvents.CLIENT_STARTED.register(this::setClient);
        ClientMinecraftEvents.CLIENT_STOPPING.register(client -> this.setClient(null));
    }

    private void setClient(@Nullable class_310 client) {
        if (client == null) {
            this.client = null;
            ModdedCrowdControlPlugin.CLIENT_AVAILABLE = false;
        } else {
            this.client = client;
            ModdedCrowdControlPlugin.CLIENT_AVAILABLE = true;
        }
    }

    @NotNull
    public Optional<class_746> player() {
        return Optional.ofNullable(this.client).map(minecraft -> minecraft.field_1724);
    }

    public static class_437 createConfigScreen(class_437 parent) {
        ModdedCrowdControlPlugin plugin = ModdedCrowdControlPlugin.getInstance();
        plugin.loadConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43471((String)"config.crowdcontrol.title")).setSavingRunnable(plugin::saveConfig);
        ConfigCategory category = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)"config.crowdcontrol.category.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((class_2561)class_2561.method_43471((String)"config.crowdcontrol.announce.name"), plugin.announceEffects()).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.crowdcontrol.announce.description")}).setSaveConsumer(plugin::setAnnounceEffects).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((class_2561)class_2561.method_43471((String)"config.crowdcontrol.hide_names.name"), HideNames.class, (Enum)plugin.getHideNames()).setDefaultValue((Enum)HideNames.NONE).setTooltip(new class_2561[]{class_2561.method_43471((String)"config.crowdcontrol.hide_names.description")}).setSaveConsumer(plugin::setHideNames).setEnumNameProvider(enumValue -> class_2561.method_43471((String)("config.crowdcontrol.hide_names.option." + ((HideNames)((Object)enumValue)).getConfigCode()))).build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((class_2561)class_2561.method_43471((String)"config.crowdcontrol.advanced_settings")).build());
        return builder.build();
    }

    public void handleRequestVersion(@NotNull RequestVersionS2C payload, @NotNull ClientPacketContext context) {
        this.logger.info("Received version request from server!");
        context.send(new ResponseVersionC2S(SemVer.MOD));
        context.send(new ExtraFeatureC2S(this.getExtraFeatures()));
    }

    public void handleSetShader(@NotNull SetShaderS2C payload, @NotNull ClientPacketContext context) {
        this.logger.debug("Received shader request from server!");
    }

    public void handleMovementStatus(@NotNull MovementStatusS2C payload, @NotNull ClientPacketContext context) {
        if (payload.statusType() == null || payload.statusValue() == null) {
            return;
        }
        context.player().cc$setMovementStatus(payload.statusType(), payload.statusValue());
    }

    public abstract void sendToServer(@NotNull class_8710 var1);

    public static void sendToServerStatic(@NotNull class_8710 payload) {
        if (INSTANCE == null) {
            return;
        }
        INSTANCE.sendToServer(payload);
    }
}

