/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_6880;

public class EnchantmentCommand
extends ModdedCommand {
    protected final class_6880<class_1887> enchantmentHolder;
    protected final class_1887 enchantment;
    private final String effectName;
    private final Component displayName;
    private final CCName extensionName;
    private final String image = "enchant_sharpness";
    private final int price = 50;
    private final byte priority = 0;
    private final List<String> categories = Collections.singletonList("Enchantments");

    public EnchantmentCommand(ModdedCrowdControlPlugin plugin, class_6880<class_1887> enchantment) {
        super(plugin);
        this.enchantmentHolder = enchantment;
        this.enchantment = (class_1887)this.enchantmentHolder.comp_349();
        this.effectName = "enchant_" + CommandConstants.csIdOf((Keyed)enchantment.method_40230().orElseThrow());
        TranslatableComponent _displayName = Component.translatable((String)"cc.effect.enchant.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure((class_2561)class_1887.method_8179(enchantment, (int)((class_1887)enchantment.comp_349()).method_8183()).method_27661().method_10862(class_2583.field_24360))});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.enchant.extension")));
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (class_3222 player : (List)playerSupplier.get()) {
                int level = this.enchantment.method_8183();
                class_1661 inv = player.method_31548();
                HashMap<class_1304, Integer> levelMap = new HashMap<class_1304, Integer>(class_1304.values().length);
                for (class_1304 slot : class_1304.values()) {
                    class_1799 item = EnchantmentCommand.getItem(inv, slot);
                    if (item.method_7960() || !this.enchantment.method_8192(item) || this.enchantment.method_8183() == this.enchantment.method_8187() && (EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder) == this.enchantment.method_8183() || EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder) == 255)) continue;
                    levelMap.put(slot, EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder));
                }
                class_1304 slot = levelMap.entrySet().stream().min(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).orElse(null);
                if (slot == null) continue;
                class_1799 item = EnchantmentCommand.getItem(inv, slot);
                int curLevel = EnchantmentCommand.getEnchantmentLevel(item, this.enchantmentHolder);
                if (curLevel >= level) {
                    level = curLevel + 1;
                }
                int setLevel = level;
                class_1890.method_57531((class_1799)item, mutable -> mutable.method_57547(this.enchantmentHolder, setLevel));
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No items could be enchanted");
        }));
    }

    public static class_1799 getItem(class_1661 inv, class_1304 slot) {
        if (slot == class_1304.field_6173) {
            return inv.method_7391();
        }
        return inv.method_5438(slot.method_32320(36));
    }

    public static int getEnchantmentLevel(class_1799 item, class_6880<class_1887> enchantment) {
        return class_1890.method_8225(enchantment, (class_1799)item);
    }

    public class_6880<class_1887> getEnchantmentHolder() {
        return this.enchantmentHolder;
    }

    public class_1887 getEnchantment() {
        return this.enchantment;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }
}

