/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;

public class PotionCommand
extends ModdedCommand
implements CCTimedEffect {
    @NotNull
    private final class_6880<class_1291> potionEffectType;
    private final boolean isMinimal;
    @NotNull
    private final String effectName;
    @NotNull
    private final Component displayName;
    private final CCName extensionName;
    private final String image = "potion_speed";
    private final int price = 50;
    private final byte priority = 0;
    private final boolean exclusive;
    private final List<String> categories = Collections.singletonList("Potion Effects");
    private final CustomEffectDuration extensionDuration = new CustomEffectDuration(20.0);

    public PotionCommand(@NotNull ModdedCrowdControlPlugin plugin, @NotNull class_6880<class_1291> potionEffectType) {
        super(plugin);
        this.potionEffectType = potionEffectType;
        class_2960 loc = ((class_5321)potionEffectType.method_40230().orElseThrow()).method_29177();
        this.effectName = "potion_" + CommandConstants.asMinimalSafeString((Key)loc);
        this.isMinimal = ((class_1291)potionEffectType.comp_349()).method_5561();
        TranslatableComponent _displayName = Component.translatable((String)"cc.effect.potion.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(((class_1291)potionEffectType.comp_349()).method_5560())});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.potion.extension")));
        this.exclusive = potionEffectType.method_55838(class_1294.field_5919) || potionEffectType.method_55838(class_1294.field_38092) || potionEffectType.method_55838(class_1294.field_5918) || potionEffectType.method_55838(class_1294.field_5912) || potionEffectType.method_55838(class_1294.field_50121) || potionEffectType.method_55838(class_1294.field_5905) || potionEffectType.method_55838(class_1294.field_5916) || potionEffectType.method_55838(class_1294.field_5925) || potionEffectType.method_55838(class_1294.field_5906) || potionEffectType.method_55838(class_1294.field_5923);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.potionEffectType == class_1294.field_5913 && this.isActive(ccPlayer, "disable_jumping")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot apply jump boost while Disable Jump is active");
            }
            Duration duration = Duration.ofMillis(request.getEffect().getDurationMillis());
            int durationTicks = this.isMinimal ? 1 : (int)duration.getSeconds() * 20;
            for (class_3222 player : (List)playerSupplier.get()) {
                class_1293 effect = new class_1293(this.potionEffectType, durationTicks);
                class_1293 existingEffect = player.method_6112(this.potionEffectType);
                if (existingEffect == null) {
                    this.plugin.getSLF4JLogger().debug("Adding new effect");
                    player.method_6092(effect);
                    continue;
                }
                this.plugin.getSLF4JLogger().debug("Updating existing effect");
                int oldDuration = existingEffect.method_5584();
                int newDuration = oldDuration == -1 ? -1 : Math.max(durationTicks, oldDuration);
                int newAmplifier = existingEffect.method_5578() + 1;
                if (this.potionEffectType == class_1294.field_5902 && newAmplifier > 127) {
                    --newAmplifier;
                }
                player.method_26082(new class_1293(this.potionEffectType, newDuration, newAmplifier, existingEffect.method_5591(), existingEffect.method_5581(), existingEffect.method_5592()), null);
            }
            return this.isMinimal ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, request.getEffect().getDurationMillis());
        }, this.plugin.getSyncExecutor()));
    }

    @NotNull
    public class_6880<class_1291> getPotionEffectType() {
        return this.potionEffectType;
    }

    public boolean isMinimal() {
        return this.isMinimal;
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public CustomEffectDuration getExtensionDuration() {
        return this.extensionDuration;
    }
}

