/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.ItemCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.InventoryUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class TakeItemCommand
extends ModdedCommand
implements ItemCommand {
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND_X;
    private final class_1792 item;
    private final String effectName;
    private final TranslatableComponent defaultDisplayName;

    public TakeItemCommand(ModdedCrowdControlPlugin plugin, class_1792 item) {
        super(plugin);
        this.item = item;
        this.effectName = "take_" + class_7923.field_41178.method_10221((Object)item).method_12832();
        this.defaultDisplayName = Component.translatable((String)"cc.effect.take_item.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(item.method_7864(new class_1799((class_1935)item)))});
    }

    private boolean takeItemFrom(class_1657 player, int amount) {
        class_1661 inventory = player.method_31548();
        int toTake = 0;
        for (class_1799 itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (!itemStack.method_7960() && itemStack.method_7909() == this.item && (toTake += itemStack.method_7947()) >= amount) break;
        }
        if (toTake < amount) {
            return false;
        }
        toTake = amount;
        for (class_1799 itemStack : InventoryUtil.viewAllItems(inventory)) {
            if (itemStack.method_7960() || itemStack.method_7909() != this.item) continue;
            int take = Math.min(toTake, itemStack.method_7947());
            itemStack.method_7934(take);
            if ((toTake -= take) != 0) continue;
            break;
        }
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getItemLimit(class_7923.field_41178.method_10221((Object)this.item).method_12832());
            int amount = request.getQuantity();
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.takeItemFrom((class_1657)player, amount);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Item could not be found in target inventories");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    public class_1792 getItem() {
        return this.item;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public TranslatableComponent getDefaultDisplayName() {
        return this.defaultDisplayName;
    }
}

