/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.adventure.minimessage.internal.serializer;

import dev.qixils.relocated.adventure.minimessage.Context;
import dev.qixils.relocated.adventure.minimessage.ParsingException;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.Emitable;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.SerializableResolver;
import dev.qixils.relocated.adventure.minimessage.tag.Tag;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.ArgumentQueue;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.TagResolver;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kyori.adventure.text.Component;

class ComponentClaimingResolverImpl
implements TagResolver,
SerializableResolver.Single {
    @NotNull
    private final Set<String> names;
    @NotNull
    private final BiFunction<ArgumentQueue, Context, Tag> handler;
    private final @NotNull Function<Component, @Nullable Emitable> componentClaim;

    ComponentClaimingResolverImpl(Set<String> names, BiFunction<ArgumentQueue, Context, Tag> handler, Function<Component, @Nullable Emitable> componentClaim) {
        this.names = names;
        this.handler = handler;
        this.componentClaim = componentClaim;
    }

    @Override
    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        if (!this.names.contains(name)) {
            return null;
        }
        return this.handler.apply(arguments, ctx);
    }

    @Override
    public boolean has(@NotNull String name) {
        return this.names.contains(name);
    }

    @Override
    @Nullable
    public Emitable claimComponent(@NotNull Component component) {
        return this.componentClaim.apply(component);
    }
}

