/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate.serialize;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.configurate.serialize.AbstractListChildSerializer;
import dev.qixils.relocated.configurate.serialize.SerializationException;
import dev.qixils.relocated.configurate.util.CheckedConsumer;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.List;

final class ListSerializer
extends AbstractListChildSerializer<List<?>> {
    static final TypeToken<List<?>> TYPE = new TypeToken<List<?>>(){};

    ListSerializer() {
    }

    @Override
    protected AnnotatedType elementType(AnnotatedType containerType) throws SerializationException {
        if (!(containerType instanceof AnnotatedParameterizedType)) {
            throw new SerializationException(containerType, "Raw types are not supported for collections");
        }
        return ((AnnotatedParameterizedType)containerType).getAnnotatedActualTypeArguments()[0];
    }

    @Override
    protected List<?> createNew(int length, AnnotatedType elementType) {
        return new ArrayList(length);
    }

    @Override
    protected void forEachElement(List<?> collection, CheckedConsumer<Object, SerializationException> action) throws SerializationException {
        for (Object el : collection) {
            action.accept(el);
        }
    }

    @Override
    protected void deserializeSingle(int index, List<?> collection, @Nullable Object deserialized) {
        collection.add(deserialized);
    }
}

