/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.http.CustomEffectDuration;
import live.crowdcontrol.cc4j.websocket.payload.CCName;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionCommand
extends PaperCommand
implements CCTimedEffect {
    @NotNull
    private final PotionEffectType potionEffectType;
    private final boolean isMinimal;
    @NotNull
    private final String effectName;
    @NotNull
    private final Component displayName;
    private final CCName extensionName;
    private final String image = "potion_speed";
    private final int price = 50;
    private final byte priority = 0;
    private final boolean exclusive;
    private final List<String> categories = Collections.singletonList("Potion Effects");
    private final CustomEffectDuration extensionDuration = new CustomEffectDuration(20.0);

    public PotionCommand(PaperCrowdControlPlugin plugin, PotionEffectType potionEffectType) {
        super(plugin);
        this.potionEffectType = potionEffectType;
        this.effectName = "potion_" + PotionCommand.nameOf(potionEffectType);
        this.isMinimal = potionEffectType.isInstant();
        TranslatableComponent _displayName = Component.translatable((String)"cc.effect.potion.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)potionEffectType)});
        this.displayName = _displayName;
        this.extensionName = new CCName(plugin.getTextUtil().asPlain((ComponentLike)_displayName.key("cc.effect.potion.extension")));
        this.exclusive = potionEffectType.equals(PotionEffectType.BLINDNESS) || potionEffectType.equals(PotionEffectType.DARKNESS) || potionEffectType.equals(PotionEffectType.FIRE_RESISTANCE) || potionEffectType.equals(PotionEffectType.GLOWING) || potionEffectType.equals(PotionEffectType.INFESTED) || potionEffectType.equals(PotionEffectType.INVISIBILITY) || potionEffectType.equals(PotionEffectType.NAUSEA) || potionEffectType.equals(PotionEffectType.NIGHT_VISION) || potionEffectType.equals(PotionEffectType.SLOW_FALLING) || potionEffectType.equals(PotionEffectType.WATER_BREATHING);
    }

    private static String nameOf(PotionEffectType type) {
        String name;
        return switch (name = type.getName()) {
            case "SLOW" -> "SLOWNESS";
            case "FAST_DIGGING" -> "HASTE";
            case "SLOW_DIGGING" -> "MINING_FATIGUE";
            case "INCREASE_DAMAGE" -> "STRENGTH";
            case "HEAL" -> "HEALING";
            case "HARM" -> "HARMING";
            case "JUMP" -> "JUMP_BOOST";
            case "CONFUSION" -> "NAUSEA";
            case "DAMAGE_RESISTANCE" -> "RESISTANCE";
            case "UNLUCK" -> "BAD_LUCK";
            default -> CommandConstants.asMinimalSafeString(type.key());
        };
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.potionEffectType == PotionEffectType.JUMP_BOOST && this.isActive(ccPlayer, "disable_jumping")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot apply jump boost while Disable Jump is active");
            }
            List players = (List)playerSupplier.get();
            Duration duration = Duration.ofMillis(request.getEffect().getDurationMillis());
            int durationTicks = this.isMinimal ? 1 : (int)duration.getSeconds() * 20;
            for (Player player : players) {
                boolean overridden = false;
                for (PotionEffect existingEffect : new ArrayList(player.getActivePotionEffects())) {
                    if (!existingEffect.getType().equals(this.potionEffectType)) continue;
                    overridden = true;
                    player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> player.removePotionEffect(this.potionEffectType), null);
                    int oldDuration = existingEffect.getDuration();
                    int newDuration = oldDuration == -1 ? -1 : Math.max(durationTicks, oldDuration);
                    int newAmplifier = existingEffect.getAmplifier() + 1;
                    if (this.potionEffectType == PotionEffectType.LEVITATION && newAmplifier > 127) {
                        --newAmplifier;
                    }
                    PotionEffect newEffect = this.potionEffectType.createEffect(newDuration, newAmplifier);
                    player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> player.addPotionEffect(newEffect), null);
                    break;
                }
                if (overridden) continue;
                player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> player.addPotionEffect(this.potionEffectType.createEffect(durationTicks, 0)), null);
            }
            return request.getEffect().getDurationMillis() > 0L ? new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, duration.toMillis()) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @NotNull
    @Generated
    public PotionEffectType getPotionEffectType() {
        return this.potionEffectType;
    }

    @Generated
    public boolean isMinimal() {
        return this.isMinimal;
    }

    @Override
    @NotNull
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    @Generated
    public CCName getExtensionName() {
        return this.extensionName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public CustomEffectDuration getExtensionDuration() {
        return this.extensionDuration;
    }
}

