/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.relocated.annotations.NotNull;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;

public class RandomFallingBlockCommand
extends RegionalCommandSync {
    private final String effectName = "falling_block_random";
    private final Map<UUID, List<Material>> blocks = new HashMap<UUID, List<Material>>();

    public RandomFallingBlockCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    public Material getRandomBlock(World world) {
        return (Material)RandomUtil.randomElementFrom(this.blocks.computeIfAbsent(world.getUID(), $ -> Registry.MATERIAL.stream().filter(mat -> mat.isBlock() && !mat.isEmpty() && mat.isSolid() && mat.isOccluding() && mat.asBlockType() != null && world.isEnabled((FeatureDependant)mat.asBlockType())).toList()));
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        Location playerLoc = player.getLocation();
        Location destination = playerLoc.clone();
        World world = destination.getWorld();
        destination.setY(Math.min(destination.getY() + 5.0, (double)(world.getMaxHeight() - 1)));
        for (int y = playerLoc.getBlockY() + 1; y < destination.getBlockY(); ++y) {
            Block block = world.getBlockAt(destination.getBlockX(), y, destination.getBlockZ());
            if (block.isPassable()) continue;
            return false;
        }
        Material block = this.getRandomBlock(player.getWorld());
        FallingBlock entity = (FallingBlock)world.createEntity(destination.toCenterLocation(), FallingBlock.class);
        entity.setBlockData(block.createBlockData());
        entity.setDamagePerBlock(0.75f);
        entity.setMaxDamage(4);
        entity.setDropItem(true);
        entity.setCancelDrop(false);
        world.addEntity((Entity)entity);
        return true;
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Unable to find valid spawning location");
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

