/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import com.destroystokyo.paper.MaterialTags;
import com.destroystokyo.paper.loottable.LootableInventory;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.paper.RegionalCommandSync;
import dev.qixils.crowdcontrol.plugin.paper.commands.EntityCommand;
import dev.qixils.crowdcontrol.plugin.paper.commands.LootboxCommand;
import dev.qixils.crowdcontrol.plugin.paper.utils.RegistryUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import io.papermc.paper.entity.CollarColorable;
import io.papermc.paper.event.player.PlayerNameEntityEvent;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Steerable;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootTables;
import org.bukkit.plugin.Plugin;

public class SummonEntityCommand
extends RegionalCommandSync
implements EntityCommand,
Listener {
    private static final Set<EquipmentSlot> HANDS = Set.of(EquipmentSlot.HAND, EquipmentSlot.OFF_HAND);
    private static final Map<EquipmentSlot, List<Material>> ARMOR;
    private static final Set<LootTables> CHEST_LOOT_TABLES;
    private static final Set<Material> BLOCKS;
    private static final Map<Rabbit.Type, Integer> RABBIT_VARIANTS;
    protected final EntityType entityType;
    private final String effectName;
    private final Component displayName;
    private final NamespacedKey mobKey;
    private final String image = "entity_creeper";
    private final int price;
    private final byte priority = (byte)5;
    private final List<String> categories = Collections.singletonList("Summon Entity");

    public SummonEntityCommand(PaperCrowdControlPlugin plugin, EntityType entityType) {
        super(plugin);
        this.entityType = entityType;
        this.effectName = "entity_" + CommandConstants.csIdOf((Keyed)entityType);
        this.displayName = Component.translatable((String)"cc.effect.summon_entity.name", (ComponentLike[])new ComponentLike[]{Component.translatable((Translatable)entityType)});
        this.mobKey = SummonEntityCommand.getMobKey((Plugin)plugin.getPaperPlugin());
        this.price = entityType.getEntityClass() != null && Enemy.class.isAssignableFrom(entityType.getEntityClass()) ? 1000 : 5000;
    }

    @NotNull
    protected static NamespacedKey getMobKey(Plugin plugin) {
        return new NamespacedKey(plugin, "isViewerSpawned");
    }

    public static boolean isMobViewerSpawned(Plugin plugin, Entity entity) {
        return (Boolean)entity.getPersistentDataContainer().getOrDefault(SummonEntityCommand.getMobKey(plugin), PaperCrowdControlPlugin.BOOLEAN_TYPE, (Object)false);
    }

    @Override
    protected int getPlayerLimit() {
        return this.getPlugin().getLimitConfig().getEntityLimit(this.entityType.getKey().getKey());
    }

    @Override
    @NotNull
    protected CCEffectResponse buildFailure(@NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Failed to spawn entity; likely not supported by this version of Minecraft");
    }

    @Override
    @Nullable
    protected CCEffectResponse precheck(@NotNull @NotNull List<@NotNull Player> players, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return this.tryExecute(players, request, ccPlayer);
    }

    @Override
    protected boolean executeRegionallySync(@NotNull Player player, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        return this.spawnEntity(this.plugin.getViewerComponentOrNull(request, false), player) != null;
    }

    protected static Entity spawnEntity(@Nullable Component viewer, @NotNull Player player, @NotNull EntityType entityType, @NotNull NamespacedKey mobKey) {
        Villager villager;
        Horse horse;
        World world = player.getWorld();
        if (entityType == EntityType.ENDER_DRAGON && world.getEnvironment() == World.Environment.THE_END) {
            return null;
        }
        Entity entity = world.spawnEntity(player.getLocation(), entityType);
        if (viewer != null) {
            entity.customName(viewer);
            entity.setCustomNameVisible(true);
        }
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            tameable.setOwner((AnimalTamer)player);
        }
        if (entity instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.setBoatType(RandomUtil.randomElementFrom(Boat.Type.values()));
        }
        if (entity instanceof CollarColorable) {
            CollarColorable colorable = (CollarColorable)entity;
            colorable.setCollarColor(RandomUtil.randomElementFrom(DyeColor.values()));
        }
        if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            if (RandomUtil.RNG.nextDouble() < 0.01) {
                mooshroom.setVariant(MushroomCow.Variant.BROWN);
            }
        }
        if (entity instanceof Horse) {
            horse = (Horse)entity;
            if (RandomUtil.RNG.nextBoolean()) {
                horse.getInventory().setArmor(new ItemStack((Material)RandomUtil.randomElementFrom(MaterialTags.HORSE_ARMORS.getValues())));
            }
        }
        if (entity instanceof Llama) {
            Llama llama = (Llama)entity;
            if (RandomUtil.RNG.nextBoolean()) {
                llama.getInventory().setDecor(new ItemStack((Material)RandomUtil.randomElementFrom(Tag.WOOL_CARPETS.getValues())));
            }
        }
        if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            sheep.setColor(RandomUtil.randomElementFrom(DyeColor.values()));
        }
        if (entity instanceof Steerable) {
            Steerable steerable = (Steerable)entity;
            steerable.setSaddle(RandomUtil.RNG.nextBoolean());
        }
        if (entity instanceof Enderman) {
            Enderman enderman = (Enderman)entity;
            enderman.setCarriedBlock(RandomUtil.randomElementFrom(BLOCKS).createBlockData());
        }
        if (entity instanceof ChestedHorse) {
            horse = (ChestedHorse)entity;
            horse.setCarryingChest(RandomUtil.RNG.nextBoolean());
        }
        if (entity instanceof Frog) {
            Frog frog = (Frog)entity;
            frog.setVariant((Frog.Variant)RegistryUtil.random(RegistryKey.FROG_VARIANT));
        }
        if (entity instanceof Axolotl) {
            Axolotl axolotl = (Axolotl)entity;
            axolotl.setVariant(RandomUtil.randomElementFrom(Axolotl.Variant.values()));
        }
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            rabbit.setRabbitType(RandomUtil.weightedRandom(RABBIT_VARIANTS));
        }
        if (entity instanceof Villager) {
            villager = (Villager)entity;
            villager.setVillagerType((Villager.Type)RegistryUtil.random(RegistryKey.VILLAGER_TYPE));
        }
        if (entity instanceof ZombieVillager) {
            villager = (ZombieVillager)entity;
            villager.setVillagerType((Villager.Type)RegistryUtil.random(RegistryKey.VILLAGER_TYPE));
        }
        if (entity instanceof LootableInventory) {
            LootableInventory lootable = (LootableInventory)entity;
            lootable.setLootTable(RandomUtil.randomElementFrom(CHEST_LOOT_TABLES).getLootTable());
        }
        if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.setCatType((Cat.Type)RegistryUtil.random(RegistryKey.CAT_VARIANT));
        }
        if (entity instanceof Wolf) {
            Wolf wolf = (Wolf)entity;
            wolf.setVariant((Wolf.Variant)RegistryUtil.random(RegistryKey.WOLF_VARIANT));
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            EntityEquipment equipment = armorStand.getEquipment();
            ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(ARMOR.keySet());
            Collections.shuffle(slots, random);
            int odds = 4;
            for (EquipmentSlot slot : slots) {
                if (random.nextInt(odds) > 0) continue;
                ItemStack item = new ItemStack(RandomUtil.randomElementFrom(ARMOR.get(slot)));
                LootboxCommand.randomlyModifyItem(item, (odds += 2) / 4, null);
                equipment.setItem(slot, item, true);
            }
            if (RandomUtil.RNG.nextBoolean()) {
                armorStand.setArms(true);
                for (EquipmentSlot slot : HANDS) {
                    if (!RandomUtil.RNG.nextBoolean()) continue;
                    equipment.setItem(slot, LootboxCommand.createRandomItem(RandomUtil.RNG.nextInt(6), null), true);
                }
            }
        }
        entity.getPersistentDataContainer().set(mobKey, PaperCrowdControlPlugin.BOOLEAN_TYPE, (Object)true);
        return entity;
    }

    protected Entity spawnEntity(@Nullable Component viewer, @NotNull Player player) {
        return SummonEntityCommand.spawnEntity(viewer, player, this.entityType, this.mobKey);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNameTag(PlayerNameEntityEvent event) {
        LivingEntity entity = event.getEntity();
        if (!SummonEntityCommand.isMobViewerSpawned((Plugin)this.plugin.getPaperPlugin(), (Entity)entity)) {
            return;
        }
        entity.getPersistentDataContainer().remove(this.getMobKey());
    }

    @Override
    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public Component getDisplayName() {
        return this.displayName;
    }

    @Generated
    public NamespacedKey getMobKey() {
        return this.mobKey;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }

    static {
        RABBIT_VARIANTS = Map.of(Rabbit.Type.BLACK, 16, Rabbit.Type.BROWN, 16, Rabbit.Type.GOLD, 16, Rabbit.Type.SALT_AND_PEPPER, 16, Rabbit.Type.WHITE, 16, Rabbit.Type.BLACK_AND_WHITE, 16, Rabbit.Type.THE_KILLER_BUNNY, 1);
        EnumMap armor = new EnumMap(EquipmentSlot.class);
        for (Material material : Registry.MATERIAL) {
            EquipmentSlot slot;
            if (!material.isItem() || (slot = material.getEquipmentSlot()) == EquipmentSlot.HAND || slot == EquipmentSlot.OFF_HAND) continue;
            armor.computeIfAbsent(slot, $ -> new ArrayList()).add(material);
        }
        for (Map.Entry entry : Set.copyOf(armor.entrySet())) {
            armor.put((EquipmentSlot)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        ARMOR = Collections.unmodifiableMap(armor);
        EnumSet<LootTables> lootTables = EnumSet.noneOf(LootTables.class);
        for (LootTables lootTable : Registry.LOOT_TABLES) {
            String key = lootTable.getKey().getKey();
            if (!key.startsWith("chests/")) continue;
            lootTables.add(lootTable);
        }
        CHEST_LOOT_TABLES = Collections.unmodifiableSet(lootTables);
        HashSet<Material> hashSet = new HashSet<Material>();
        for (Material material : Registry.MATERIAL) {
            if (!material.isBlock()) continue;
            hashSet.add(material);
        }
        BLOCKS = Collections.unmodifiableSet(hashSet);
    }
}

