/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.paper.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.paper.PaperCommand;
import dev.qixils.crowdcontrol.plugin.paper.PaperCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SwapCommand
extends PaperCommand {
    private final String effectName = "swap";

    public SwapCommand(PaperCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull Player>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            if (players.size() < 2) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Not enough participating players online");
            }
            Collections.shuffle(players, random);
            ArrayList offset = new ArrayList(players.size());
            offset.addAll(players.subList(1, players.size()));
            offset.add((Player)players.getFirst());
            HashMap<Player, Location> destinations = new HashMap<Player, Location>(players.size());
            for (int i = 0; i < players.size(); ++i) {
                destinations.put((Player)players.get(i), ((Player)offset.get(i)).getLocation());
            }
            destinations.forEach((player, location) -> player.getScheduler().run((Plugin)this.plugin.getPaperPlugin(), $ -> player.teleportAsync(location), null));
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
        }));
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<Player> potentialPlayers) {
        return this.plugin.getPlayerManager().getPotentialPlayers(user).count() <= 1L ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

