/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.bukkit.parser;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.cloud.bukkit.BukkitCaptionKeys;
import dev.qixils.relocated.cloud.caption.CaptionVariable;
import dev.qixils.relocated.cloud.component.CommandComponent;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.exception.parsing.ParserException;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ArgumentParser;
import dev.qixils.relocated.cloud.parser.ParserDescriptor;
import dev.qixils.relocated.cloud.suggestion.BlockingSuggestionProvider;
import java.util.ArrayList;
import org.apiguardian.api.API;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public final class EnchantmentParser<C>
implements ArgumentParser<C, Enchantment>,
BlockingSuggestionProvider.Strings<C> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, Enchantment> enchantmentParser() {
        return ParserDescriptor.of(new EnchantmentParser<C>(), Enchantment.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, Enchantment> enchantmentComponent() {
        return CommandComponent.builder().parser(EnchantmentParser.enchantmentParser());
    }

    @Override
    public @NonNull ArgumentParseResult<Enchantment> parse(@NonNull CommandContext<C> commandContext, @NonNull CommandInput commandInput) {
        NamespacedKey key;
        String input = commandInput.peekString();
        try {
            key = input.contains(":") ? new NamespacedKey(commandInput.readUntilAndSkip(':'), commandInput.readString()) : NamespacedKey.minecraft((String)commandInput.readString());
        }
        catch (Exception ex) {
            return ArgumentParseResult.failure(new EnchantmentParseException(input, commandContext));
        }
        Enchantment enchantment = Enchantment.getByKey((NamespacedKey)key);
        if (enchantment == null) {
            return ArgumentParseResult.failure(new EnchantmentParseException(input, commandContext));
        }
        return ArgumentParseResult.success(enchantment);
    }

    @Override
    public @NonNull Iterable<@NonNull String> stringSuggestions(@NonNull CommandContext<C> commandContext, @NonNull CommandInput input) {
        ArrayList<String> completions = new ArrayList<String>();
        for (Enchantment value : Enchantment.values()) {
            if (value.getKey().getNamespace().equals("minecraft")) {
                completions.add(value.getKey().getKey());
                continue;
            }
            completions.add(value.getKey().toString());
        }
        return completions;
    }

    public static final class EnchantmentParseException
    extends ParserException {
        private final String input;

        public EnchantmentParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(EnchantmentParser.class, context, BukkitCaptionKeys.ARGUMENT_PARSE_FAILURE_ENCHANTMENT, CaptionVariable.of("input", input));
            this.input = input;
        }

        public @NonNull String input() {
            return this.input;
        }
    }
}

