/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.cloud.parser;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.NonNull;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.cloud.context.CommandContext;
import dev.qixils.relocated.cloud.context.CommandInput;
import dev.qixils.relocated.cloud.parser.ArgumentParseResult;
import dev.qixils.relocated.cloud.parser.ArgumentParser;
import dev.qixils.relocated.cloud.parser.MappedArgumentParser;
import dev.qixils.relocated.cloud.suggestion.SuggestionProvider;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;

@API(status=API.Status.INTERNAL)
public final class MappedArgumentParserImpl<C, I, O>
implements MappedArgumentParser<C, I, O>,
ArgumentParser.FutureArgumentParser<C, O> {
    private final ArgumentParser<C, I> base;
    private final MappedArgumentParser.Mapper<C, I, O> mapper;

    MappedArgumentParserImpl(ArgumentParser<C, I> base, MappedArgumentParser.Mapper<C, I, O> mapper) {
        this.base = base;
        this.mapper = mapper;
    }

    @Override
    public @NonNull ArgumentParser<C, I> baseParser() {
        return this.base;
    }

    @Override
    public @NonNull CompletableFuture<@NonNull ArgumentParseResult<O>> parseFuture(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        return this.base.parseFuture(commandContext, commandInput).thenCompose(result -> this.mapper.map(commandContext, (ArgumentParseResult<I>)result));
    }

    @Override
    public @NonNull SuggestionProvider<C> suggestionProvider() {
        return this.base.suggestionProvider();
    }

    @Override
    public <O1> @NonNull ArgumentParser.FutureArgumentParser<C, O1> flatMap(MappedArgumentParser.Mapper<C, O, O1> mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return new MappedArgumentParserImpl(this.base, (ctx, orig) -> this.mapper.map(ctx, orig).thenCompose(mapped -> mapper.map(ctx, (ArgumentParseResult)mapped)));
    }

    public int hashCode() {
        return 31 + this.base.hashCode() + 7 * this.mapper.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof MappedArgumentParserImpl)) {
            return false;
        }
        MappedArgumentParserImpl that = (MappedArgumentParserImpl)other;
        return this.base.equals(that.base) && this.mapper.equals(that.mapper);
    }

    public String toString() {
        return "MappedArgumentParserImpl{base=" + this.base + ',' + "mapper=" + this.mapper + '}';
    }
}

