/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.food;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.command.QuantityStyle;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;

public class FoodAddCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "feed";
    @NotNull
    private final QuantityStyle quantityStyle = QuantityStyle.APPEND;
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        int amount = request.getQuantity() * 2;
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                int currFood = player.foodLevel();
                double currSaturation = player.saturation();
                int newFood = Math.min(20, currFood + amount);
                if (newFood - currFood != amount && !((double)newFood - currSaturation >= (double)amount)) continue;
                this.sync(() -> {
                    player.foodLevel(newFood);
                    player.saturation(newFood);
                });
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Player's hunger is already max");
        }));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    public QuantityStyle getQuantityStyle() {
        return this.quantityStyle;
    }

    @Override
    @NotNull
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }

    public FoodAddCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }
}

