/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.sound.Sounds;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.IUserRecord;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_3222;

public class KeepInventoryCommand
extends ModdedCommand {
    private static final Set<UUID> keepingInventory = Collections.synchronizedSet(new HashSet(1));
    public static boolean globalKeepInventory = false;
    private final boolean enable;
    private final String effectName;

    public KeepInventoryCommand(ModdedCrowdControlPlugin plugin, boolean enable) {
        super(plugin);
        this.enable = enable;
        this.effectName = "keep_inventory_" + (enable ? "on" : "off");
    }

    public static boolean isKeepingInventory(UUID player) {
        return globalKeepInventory || keepingInventory.contains(player);
    }

    public static boolean isKeepingInventory(class_1297 player) {
        return KeepInventoryCommand.isKeepingInventory(player.method_5667());
    }

    private void alert(List<class_3222> players) {
        Audience audience = this.plugin.playerMapper().asAudience(players);
        audience.sendActionBar(this.enable ? CommandConstants.KEEP_INVENTORY_MESSAGE : CommandConstants.LOSE_INVENTORY_MESSAGE);
        audience.playSound((this.enable ? Sounds.KEEP_INVENTORY_ALERT : Sounds.LOSE_INVENTORY_ALERT).get(new Object[0]), Sound.Emitter.self());
    }

    @Override
    public void execute(@NotNull Supplier<List<class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            if (this.plugin.isGlobal()) {
                if (globalKeepInventory == this.enable) {
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Keep Inventory is already " + (this.enable ? "enabled" : "disabled"));
                }
                globalKeepInventory = this.enable;
                this.alert(players);
                this.plugin.updateConditionalEffectVisibility();
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            ArrayList<UUID> uuids = new ArrayList<UUID>(players.size());
            for (class_3222 player : players) {
                uuids.add(player.method_5667());
            }
            if (this.enable) {
                if (keepingInventory.addAll(uuids)) {
                    this.alert(players);
                    players.forEach(this.plugin::updateConditionalEffectVisibility);
                    return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
                }
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory enabled");
            }
            if (keepingInventory.removeAll(uuids)) {
                this.alert(players);
                players.forEach(this.plugin::updateConditionalEffectVisibility);
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS);
            }
            return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Streamer(s) already have Keep Inventory disabled");
        }));
    }

    @Override
    public TriState isVisible(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        return potentialPlayers.stream().anyMatch(player -> player.method_51469().method_64395().method_8355(class_1928.field_19389)) ? TriState.FALSE : TriState.TRUE;
    }

    @Override
    public TriState isSelectable(@NotNull IUserRecord user, @NotNull List<class_3222> potentialPlayers) {
        if (this.plugin.isGlobal()) {
            return globalKeepInventory == this.enable ? TriState.FALSE : TriState.TRUE;
        }
        TriState state = potentialPlayers.stream().map(player -> TriState.fromBoolean(this.enable != KeepInventoryCommand.isKeepingInventory(player.method_5667()))).reduce((prev, next) -> {
            if (prev != next) {
                return TriState.UNKNOWN;
            }
            return prev;
        }).orElse(TriState.UNKNOWN);
        if (state == TriState.FALSE) {
            return state;
        }
        return TriState.TRUE;
    }

    public boolean isEnable() {
        return this.enable;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }
}

