/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.packets.util.LanguageState;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.packets.SetLanguageS2C;
import dev.qixils.relocated.annotations.NotNull;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.CCTimedEffect;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCTimedEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_3222;

public class LanguageCommand
extends ModdedCommand
implements CCTimedEffect {
    @NotNull
    private final String effectName = "language_random";
    @NotNull
    private final Duration defaultDuration = Duration.ofSeconds(30L);
    @NotNull
    private final SemVer minimumModVersion = LanguageState.RANDOM.addedIn();
    @NotNull
    private final Set<ExtraFeature> requiredExtraFeatures = EnumSet.of(ExtraFeature.LANGUAGE_RELOAD);

    public LanguageCommand(@NotNull ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull Supplier<List<class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, this.getEffectArray())) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players already have an active language effect");
            }
            List players = (List)playerSupplier.get();
            Duration duration = Duration.ofSeconds(request.getEffect().getDurationMillis());
            SetLanguageS2C packet = new SetLanguageS2C(LanguageState.RANDOM, duration);
            for (class_3222 player : players) {
                this.plugin.sendToPlayer(player, packet);
            }
            return new CCTimedEffectResponse(request.getRequestId(), ResponseStatus.TIMED_BEGIN, duration.toMillis());
        }));
    }

    @Override
    @NotNull
    public String getEffectName() {
        return this.effectName;
    }

    @NotNull
    public Duration getDefaultDuration() {
        return this.defaultDuration;
    }

    @Override
    @NotNull
    public SemVer getMinimumModVersion() {
        return this.minimumModVersion;
    }

    @Override
    @NotNull
    public Set<ExtraFeature> requiredExtraFeatures() {
        return this.requiredExtraFeatures;
    }
}

