/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import com.mojang.datafixers.util.Pair;
import dev.qixils.crowdcontrol.common.util.TextUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.NearbyLocationCommand;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6885;
import net.minecraft.class_7058;
import net.minecraft.class_7924;

public class StructureCommand
extends NearbyLocationCommand<StructureGroup> {
    private static final Map<class_5321<class_1937>, List<StructureGroup>> STRUCTURES = Map.of(class_1937.field_25179, List.of(StructureGroup.VILLAGE, StructureGroup.PILLAGER_OUTPOST, StructureGroup.MINESHAFT, StructureGroup.WOODLAND_MANSION, StructureGroup.JUNGLE_TEMPLE, StructureGroup.DESERT_PYRAMID, StructureGroup.IGLOO, StructureGroup.SHIPWRECK, StructureGroup.SWAMP_HUT, StructureGroup.STRONGHOLD, StructureGroup.OCEAN_MONUMENT, StructureGroup.OCEAN_RUIN, StructureGroup.BURIED_TREASURE, StructureGroup.RUINED_PORTAL), class_1937.field_25180, List.of(StructureGroup.NETHER_FORTRESS, StructureGroup.BASTION_REMNANT, StructureGroup.RUINED_PORTAL_NETHER), class_1937.field_25181, List.of(StructureGroup.END_CITY));
    private final String effectName = "structure";

    public StructureCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    @Nullable
    protected Location search(@NotNull Location origin, @NotNull StructureGroup searchType) {
        Pair pair = origin.level().method_14178().method_12129().method_12103(origin.level(), searchType.getStructures(origin.level()), origin.pos(), 64, false);
        if (pair == null) {
            return null;
        }
        return new Location(origin.level(), (class_2338)pair.getFirst());
    }

    @Override
    @NotNull
    protected Collection<StructureGroup> getSearchTypes(@NotNull class_3218 level) {
        return STRUCTURES.get(level.method_27983());
    }

    @Override
    @NotNull
    protected Component nameOf(@NotNull StructureGroup searchType) {
        return searchType.name;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    static enum StructureGroup {
        PILLAGER_OUTPOST(class_7058.field_37168),
        MINESHAFT(class_7058.field_37169, class_7058.field_37170),
        WOODLAND_MANSION(class_7058.field_37171),
        JUNGLE_TEMPLE(class_7058.field_37172),
        DESERT_PYRAMID(class_7058.field_37173),
        IGLOO(class_7058.field_37174),
        SHIPWRECK(class_7058.field_37175, class_7058.field_37176),
        SWAMP_HUT(class_7058.field_37177),
        STRONGHOLD(class_7058.field_37178),
        OCEAN_MONUMENT(class_7058.field_37179),
        OCEAN_RUIN(class_7058.field_37180, class_7058.field_37181),
        NETHER_FORTRESS("Fortress", class_7058.field_37182),
        NETHER_FOSSIL(class_7058.field_37183),
        END_CITY(class_7058.field_37184),
        BURIED_TREASURE(class_7058.field_37185),
        BASTION_REMNANT(class_7058.field_37186),
        VILLAGE(class_7058.field_37187, class_7058.field_37189, class_7058.field_37190, class_7058.field_37191, class_7058.field_37188),
        RUINED_PORTAL(class_7058.field_37192, class_7058.field_37193, class_7058.field_37163, class_7058.field_37164, class_7058.field_37165, class_7058.field_37166),
        RUINED_PORTAL_NETHER("Ruined Portal", class_7058.field_37167),
        ANCIENT_CITY(class_7058.field_38428);

        private final Component name;
        private final class_5321<class_3195>[] structures;

        @SafeVarargs
        private StructureGroup(String name, class_5321<class_3195> ... structures) {
            this((Component)Component.text((String)name), structures);
        }

        @SafeVarargs
        private StructureGroup(Component name, class_5321<class_3195> ... structures) {
            this.name = name;
            this.structures = structures;
        }

        @SafeVarargs
        private StructureGroup(class_5321<class_3195> ... structures) {
            this.name = Component.text((String)TextUtil.titleCase(this));
            this.structures = structures;
        }

        class_6885<class_3195> getStructures(class_3218 level) {
            class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
            return class_6885.method_40242(Arrays.stream(this.structures).map(arg_0 -> ((class_2378)registry).method_46746(arg_0)).flatMap(Optional::stream).toList());
        }
    }
}

