/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.EntityCommand;
import dev.qixils.crowdcontrol.plugin.fabric.commands.LootboxCommand;
import dev.qixils.relocated.annotations.Blocking;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1438;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1492;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1531;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3851;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5762;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7225;
import net.minecraft.class_7265;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class SummonEntityCommand<E extends class_1297>
extends ModdedCommand
implements EntityCommand<E> {
    private static final Set<class_1304> HANDS = Arrays.stream(class_1304.values()).filter(slot -> slot.method_5925() == class_1304.class_1305.field_6177).collect(Collectors.toSet());
    protected final class_1299<? extends E> entityType;
    protected final class_1299<? extends E>[] entityTypes;
    private final String effectName;
    private final Component displayName;
    private final String image = "entity_creeper";
    private final int price;
    private final byte priority = (byte)5;
    private final List<String> categories = Collections.singletonList("Summon Entity");
    private static List<class_5321<class_52>> LOOT_TABLES = null;
    private static final Map<class_1299<?>, List<class_1792>> HORSE_ARMOR = new HashMap();
    private static final Map<class_1463.class_7990, Integer> RABBIT_VARIANTS = Map.of(class_1463.class_7990.field_41563, 16, class_1463.class_7990.field_41561, 16, class_1463.class_7990.field_41565, 16, class_1463.class_7990.field_41566, 16, class_1463.class_7990.field_41562, 16, class_1463.class_7990.field_41564, 16, class_1463.class_7990.field_41567, 1);
    private static final Map<class_1304, List<class_1792>> HUMANOID_ARMOR;

    public SummonEntityCommand(ModdedCrowdControlPlugin plugin, class_1299<E> entityType) {
        this(plugin, "entity_" + CommandConstants.csIdOf((Keyed)class_7923.field_41177.method_10221(entityType)), (Component)Component.translatable((String)"cc.effect.summon_entity.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(entityType.method_5897())}), entityType, new class_1299[0]);
    }

    @SafeVarargs
    public SummonEntityCommand(ModdedCrowdControlPlugin plugin, String effectName, @Nullable Component displayName, class_1299<? extends E> firstEntity, class_1299<? extends E> ... otherEntities) {
        super(plugin);
        this.entityType = firstEntity;
        this.entityTypes = new class_1299[1 + otherEntities.length];
        this.entityTypes[0] = firstEntity;
        System.arraycopy(otherEntities, 0, this.entityTypes, 1, otherEntities.length);
        this.effectName = effectName;
        this.displayName = displayName;
        int _price = 500;
        try {
            if (firstEntity.method_5883((class_1937)plugin.server().method_30002(), class_3730.field_16462) instanceof class_1569) {
                _price = 1000;
            }
        }
        catch (Exception e) {
            plugin.getSLF4JLogger().debug("Could not generate default price for {}", (Object)class_7923.field_41177.method_10221(firstEntity), (Object)e);
        }
        this.price = _price;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    public class_1299<? extends E> getRandomEntityType() {
        return RandomUtil.randomElementFrom(this.entityTypes);
    }

    private static List<class_5321<class_52>> getLOOT_TABLES(MinecraftServer server) {
        if (LOOT_TABLES != null) {
            return LOOT_TABLES;
        }
        LOOT_TABLES = ((class_7225.class_7874)server.method_58576().method_58294()).method_46762(class_7924.field_50079).method_46754().filter(key -> key.method_29177().method_12832().startsWith("chests/")).toList();
        return LOOT_TABLES;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getEntityLimit(this.getEffectName().replace("entity_", ""));
            CCEffectResponse tryExecute = this.tryExecute(players, request, ccPlayer);
            if (tryExecute != null) {
                return tryExecute;
            }
            Component name = this.plugin.getViewerComponentOrNull(request, false);
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.spawnEntity(name, (class_3222)player) != null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_PERMANENT, "Failed to spawn entity");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Blocking
    protected static <E extends class_1297> E spawnEntity(@Nullable Component viewer, @NotNull class_3222 player, @NotNull class_1299<E> entityType, @NotNull ModdedCrowdControlPlugin plugin) {
        class_1309 livingEntity;
        class_3218 level = player.method_51469();
        if (entityType == class_1299.field_6116 && level.method_29198() != null) {
            return null;
        }
        class_1297 entity = entityType.method_5883((class_1937)player.method_51469(), class_3730.field_16462);
        if (entity == null) {
            throw new IllegalStateException("Could not spawn entity");
        }
        entity.method_33574(player.method_19538());
        if (viewer != null) {
            entity.method_5665(plugin.toNative(viewer, (Pointered)player));
            entity.method_5880(true);
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            mob.method_5943((class_5425)level, level.method_8404(entity.method_24515()), class_3730.field_16462, null);
        }
        if (entity instanceof class_1321) {
            class_1321 tamable = (class_1321)entity;
            tamable.method_6170((class_1657)player);
        }
        if (entity instanceof class_1309) {
            livingEntity = (class_1309)entity;
            livingEntity.cc$setViewerSpawned();
        }
        if (entity instanceof class_1493) {
            class_1493 wolf = (class_1493)entity;
            wolf.method_6708(RandomUtil.randomElementFrom(class_1767.values()));
            wolf.method_58063((class_6880)RandomUtil.randomElementFrom(level.method_30349().method_30530(class_7924.field_49772).method_42017()));
        }
        if (entity instanceof class_1438) {
            class_1438 mooshroom = (class_1438)entity;
            if (RandomUtil.RNG.nextDouble() < 0.01) {
                mooshroom.method_47846(class_1438.class_4053.field_18110);
            }
        }
        if (entity instanceof class_1496) {
            class_1496 horse = (class_1496)entity;
            if (horse.method_56991(class_1304.field_48824) && RandomUtil.RNG.nextBoolean()) {
                List items = HORSE_ARMOR.computeIfAbsent(entityType, $ -> class_7923.field_41178.method_10220().filter(item -> {
                    class_10192 equippable = (class_10192)item.method_57347().method_58694(class_9334.field_54196);
                    if (equippable == null) {
                        return false;
                    }
                    return equippable.comp_3174().method_5925() == class_1304.class_1305.field_48825;
                }).toList());
                horse.method_32318(401).method_32332(new class_1799((class_1935)RandomUtil.randomElementFrom(items)));
            }
            horse.method_66323((class_1309)player);
            horse.method_6766(true);
        }
        if (entity instanceof class_1472) {
            class_1472 sheep = (class_1472)entity;
            sheep.method_6631(RandomUtil.randomElementFrom(class_1767.values()));
        }
        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_56991(class_1304.field_55946) && RandomUtil.RNG.nextBoolean()) {
            livingEntity.method_5673(class_1304.field_55946, new class_1799((class_1935)class_1802.field_8175));
        }
        if (entity instanceof class_1560) {
            class_1560 enderman = (class_1560)entity;
            enderman.method_7032(((class_2248)RandomUtil.randomElementFrom(class_7923.field_41175)).method_9564());
        }
        if (entity instanceof class_1492) {
            class_1492 chested = (class_1492)entity;
            chested.method_6704(RandomUtil.RNG.nextBoolean());
        }
        if (entity instanceof class_7102) {
            class_7102 frog = (class_7102)entity;
            frog.method_41353((class_6880)RandomUtil.randomElementFrom(level.method_30349().method_30530(class_7924.field_41272).method_42017()));
        }
        if (entity instanceof class_5762) {
            class_5762 axolotl = (class_5762)entity;
            axolotl.method_33219(RandomUtil.randomElementFrom(class_5762.class_5767.values()));
        }
        if (entity instanceof class_1463) {
            class_1463 rabbit = (class_1463)entity;
            rabbit.method_47853(RandomUtil.weightedRandom(RABBIT_VARIANTS));
        }
        if (entity instanceof class_3851) {
            class_3851 villager = (class_3851)entity;
            villager.method_7195(villager.method_7231().method_16922((class_6880)RandomUtil.randomElementFrom(class_7923.field_41194.method_42017())));
        }
        if (entity instanceof class_7265) {
            class_7265 container = (class_7265)entity;
            container.method_42275(RandomUtil.randomElementFrom(SummonEntityCommand.getLOOT_TABLES(level.method_8503())));
        }
        if (entity instanceof class_1531) {
            class_1531 armorStand = (class_1531)entity;
            ArrayList<class_1304> slots = new ArrayList<class_1304>(HUMANOID_ARMOR.keySet());
            Collections.shuffle(slots, random);
            int odds = 4;
            for (class_1304 type : slots) {
                if (random.nextInt(odds) > 0) continue;
                class_1799 item = new class_1799((class_1935)RandomUtil.randomElementFrom(HUMANOID_ARMOR.get(type)));
                plugin.commandRegister().getCommandByName("lootbox", LootboxCommand.class).randomlyModifyItem(item, (odds += 2) / 4, level.method_30349());
                armorStand.method_5673(type, item);
            }
            if (RandomUtil.RNG.nextBoolean()) {
                armorStand.method_6913(true);
                for (class_1304 slot : HANDS) {
                    if (!RandomUtil.RNG.nextBoolean()) continue;
                    armorStand.method_5673(slot, plugin.commandRegister().getCommandByName("lootbox", LootboxCommand.class).createRandomItem(RandomUtil.RNG.nextInt(6), level.method_30349()));
                }
            }
        }
        level.method_8649(entity);
        return (E)entity;
    }

    @Blocking
    protected E spawnEntity(@Nullable Component viewer, @NotNull class_3222 player) {
        return SummonEntityCommand.spawnEntity(viewer, player, this.getRandomEntityType(), this.plugin);
    }

    @Override
    public class_1299<? extends E> getEntityType() {
        return this.entityType;
    }

    public class_1299<? extends E>[] getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public int getPrice() {
        return this.price;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    static {
        HashMap armor = new HashMap(4);
        for (class_1792 item : class_7923.field_41178) {
            class_1304 slot2;
            class_10192 equippable = (class_10192)item.method_57347().method_58694(class_9334.field_54196);
            if (equippable == null || (slot2 = equippable.comp_3174()).method_5925() != class_1304.class_1305.field_6178) continue;
            armor.computeIfAbsent(slot2, $ -> new ArrayList()).add(item);
        }
        for (Map.Entry entry : new HashSet(armor.entrySet())) {
            armor.put((class_1304)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        HUMANOID_ARMOR = Collections.unmodifiableMap(armor);
    }
}

