/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.RandomUtil;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.common.util.Weighted;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.BlockFinder;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.Contract;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class VeinCommand
extends ModdedCommand {
    public static final class_6862<class_2248> ORES = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"c", (String)"ores"));
    public static final class_6862<class_2248> ORE_BEARING_GROUND_DEEPSLATE = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"c", (String)"ore_bearing_ground/deepslate"));
    private final String effectName = "vein";

    public VeinCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Contract(mutates="param1, param2")
    private void addOreVein(List<Location> deepslateBlocks, List<Location> stoneBlocks, Location base) {
        for (int x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 2; ++z) {
                    Location loc = base.add(x, y, z);
                    class_2680 block = loc.block();
                    if (block.method_26164(ORE_BEARING_GROUND_DEEPSLATE)) {
                        deepslateBlocks.add(loc);
                        continue;
                    }
                    if (block.method_26215()) continue;
                    stoneBlocks.add(loc);
                }
            }
        }
    }

    @Contract(mutates="param1")
    private static void randomlyShrinkOreVein(List<Location> blockLocations) {
        if (blockLocations.isEmpty()) {
            return;
        }
        Collections.shuffle(blockLocations, random);
        int maxBlocks = 1 + random.nextInt(blockLocations.size());
        while (blockLocations.size() > maxBlocks) {
            blockLocations.removeFirst();
        }
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            boolean success = false;
            for (class_3222 player : (List)playerSupplier.get()) {
                BlockFinder finder = ((BlockFinder.BlockFinderBuilder)((BlockFinder.BlockFinderBuilder)BlockFinder.builder().origin(new Location((class_1297)player)).maxRadius(6)).locationValidator(loc -> !loc.block().method_26215())).build();
                class_2378 registry = player.method_37908().method_30349().method_30530(class_7924.field_41254);
                ArrayList<Ore> ores = new ArrayList<Ore>();
                ores.add(new Ore((class_6880<class_2248>)registry.method_47983((Object)class_2246.field_10164), 1));
                ores.add(new Ore((class_6880<class_2248>)registry.method_47983((Object)class_2246.field_10277), (class_6880<class_2248>)registry.method_47983((Object)class_2246.field_29224), 1));
                registry.method_46735(ORES).method_40239().filter(class_6880::method_40227).sorted((a, b) -> {
                    boolean deepslateB;
                    class_2960 keyA = ((class_5321)a.method_40230().get()).method_29177();
                    class_2960 keyB = ((class_5321)b.method_40230().get()).method_29177();
                    boolean deepslateA = keyA.value().startsWith("deepslate_");
                    if (deepslateA != (deepslateB = keyB.value().startsWith("deepslate_"))) {
                        return deepslateA ? 1 : -1;
                    }
                    return keyA.asString().compareTo(keyB.asString());
                }).forEachOrdered(item -> {
                    int idx;
                    Optional<Ore> matching;
                    class_2960 location = ((class_5321)item.method_40230().get()).method_29177();
                    if (location.value().startsWith("deepslate_") && (matching = ores.stream().filter(ore -> {
                        class_2960 oreLoc = ((class_5321)ore.getBlock().method_40230().get()).method_29177();
                        if (!location.namespace().equals(oreLoc.namespace())) {
                            return false;
                        }
                        return location.value().equals("deepslate_" + oreLoc.value());
                    }).findFirst()).isPresent() && (idx = ores.indexOf(matching.get())) != -1) {
                        ores.set(idx, matching.get().withDeepslate((class_6880<class_2248>)item));
                        return;
                    }
                    ores.add(new Ore((class_6880<class_2248>)item, item.method_55838(registry.method_47983((Object)class_2246.field_22109)) ? 3 : 6));
                });
                for (int iter = 0; iter < 3; ++iter) {
                    Ore ore = (Ore)RandomUtil.weightedRandom(ores);
                    ArrayList<Location> setBlocks = new ArrayList<Location>(8);
                    ArrayList<Location> setDeepslateBlocks = new ArrayList<Location>(8);
                    Location oreLocation = (Location)finder.next();
                    if (oreLocation == null) continue;
                    this.addOreVein(setDeepslateBlocks, setBlocks, oreLocation);
                    if (setBlocks.isEmpty() && setDeepslateBlocks.isEmpty()) continue;
                    success = true;
                    VeinCommand.randomlyShrinkOreVein(setBlocks);
                    VeinCommand.randomlyShrinkOreVein(setDeepslateBlocks);
                    this.sync(() -> {
                        setBlocks.forEach(blockPos -> blockPos.block(((class_2248)ore.getBlock().comp_349()).method_9564()));
                        setDeepslateBlocks.forEach(blockPos -> blockPos.block(((class_2248)ore.getDeepslateBlock().comp_349()).method_9564()));
                    });
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find any blocks to replace");
        }));
    }

    @Override
    public String getEffectName() {
        return this.effectName;
    }

    public static class Ore
    implements Weighted {
        private final class_6880<class_2248> block;
        private final class_6880<class_2248> deepslateBlock;
        private final int weight;

        Ore(class_6880<class_2248> block, class_6880<class_2248> deepslateBlock, int weight) {
            this.block = block;
            this.deepslateBlock = deepslateBlock;
            this.weight = weight;
        }

        Ore(class_6880<class_2248> block, int weight) {
            this(block, block, weight);
        }

        public Ore withDeepslate(class_6880<class_2248> deepslateBlock) {
            return new Ore(this.block, deepslateBlock, this.weight);
        }

        public class_6880<class_2248> getBlock() {
            return this.block;
        }

        public class_6880<class_2248> getDeepslateBlock() {
            return this.deepslateBlock;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }
    }
}

