/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.utils;

import dev.qixils.crowdcontrol.plugin.fabric.utils.ParticleEffectBuilder;
import dev.qixils.relocated.annotations.CheckReturnValue;
import dev.qixils.relocated.annotations.Contract;
import java.util.Collections;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6319;
import net.minecraft.class_6328;
import org.joml.Vector3d;
import org.joml.Vector3f;

@class_6319
@class_6328
public record Location(class_3218 level, double x, double y, double z, float yaw, float pitch) {
    public Location(class_1297 player) {
        this((class_3218)player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
    }

    public Location(class_3218 level, double x, double y, double z) {
        this(level, x, y, z, 0.0f, 0.0f);
    }

    public Location(class_3218 level, class_2338 pos, float yaw, float pitch) {
        this(level, pos.method_10263(), pos.method_10264(), pos.method_10260(), yaw, pitch);
    }

    public Location(class_3218 level, class_2338 pos) {
        this(level, pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public class_2338 pos() {
        return class_2338.method_49637((double)this.x, (double)this.y, (double)this.z);
    }

    public class_243 vec3() {
        return new class_243(this.x, this.y, this.z);
    }

    public Vector3d vector3d() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public Vector3f vector3f() {
        return new Vector3f((float)this.x, (float)this.y, (float)this.z);
    }

    public void teleportHere(class_3222 player) {
        player.method_48105(this.level, this.x, this.y, this.z, Collections.emptySet(), this.yaw, this.pitch, false);
    }

    @CheckReturnValue
    @Contract(value="_, _, _ -> new")
    public Location add(double x, double y, double z) {
        return new Location(this.level, this.x + x, this.y + y, this.z + z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="-> new")
    public Location atVertCeil() {
        return new Location(this.level, this.x, Math.ceil(this.y), this.z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location at(class_2338 pos) {
        return new Location(this.level, pos, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_, _ -> new")
    public Location withRotation(float yaw, float pitch) {
        return new Location(this.level, this.x, this.y, this.z, yaw, pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location withRotationOf(Location other) {
        return new Location(this.level, this.x, this.y, this.z, other.yaw, other.pitch);
    }

    @CheckReturnValue
    @Contract(value="_, _, _ -> new")
    public Location withPosition(double x, double y, double z) {
        return new Location(this.level, x, y, z, this.yaw, this.pitch);
    }

    @CheckReturnValue
    @Contract(value="_ -> new")
    public Location withPositionOf(Location other) {
        return new Location(other.level, other.x, other.y, other.z, this.yaw, this.pitch);
    }

    public class_2680 block() {
        return this.level.method_8320(this.pos());
    }

    public void block(class_2680 state) {
        this.level.method_8501(this.pos(), state);
    }

    public <T extends class_2394> ParticleEffectBuilder<T> buildParticleEffect(T options) {
        return new ParticleEffectBuilder<T>(options).level(this.level).position(this.vector3d());
    }

    public Location relative(class_2350 direction) {
        return new Location(this.level, this.x + (double)direction.method_10148(), this.y + (double)direction.method_10164(), this.z + (double)direction.method_10165(), this.yaw, this.pitch);
    }

    public double squareDistanceTo(Location o) {
        return Math.pow(this.x - o.x, 2.0) + Math.pow(this.y - o.y, 2.0) + Math.pow(this.z - o.z, 2.0);
    }
}

