/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.adventure.minimessage.tag.standard;

import dev.qixils.relocated.adventure.minimessage.Context;
import dev.qixils.relocated.adventure.minimessage.ParsingException;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.Emitable;
import dev.qixils.relocated.adventure.minimessage.internal.serializer.SerializableResolver;
import dev.qixils.relocated.adventure.minimessage.tag.Tag;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.ArgumentQueue;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.TagResolver;
import dev.qixils.relocated.adventure.minimessage.tag.standard.StandardTags;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.TranslationArgument;

final class TranslatableTag {
    private static final String TR = "tr";
    private static final String TRANSLATE = "translate";
    private static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        List with;
        String key = args.popOr("A translation key is required").value();
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting((Component)Component.translatable((String)key, with));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() != null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG);
            emit.argument(tr.key());
            for (TranslationArgument with : tr.arguments()) {
                emit.argument(with.asComponent());
            }
        };
    }
}

