/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.relocated.configurate.transformation;

import dev.qixils.relocated.checkerframework.checker.nullness.qual.Nullable;
import dev.qixils.relocated.configurate.ConfigurateException;
import dev.qixils.relocated.configurate.ConfigurationNode;
import dev.qixils.relocated.configurate.NodePath;
import io.leangen.geantyref.TypeToken;
import java.util.function.Supplier;

@FunctionalInterface
public interface TransformAction {
    public static TransformAction remove() {
        return (path, value) -> {
            value.raw(null);
            return null;
        };
    }

    public static TransformAction rename(Object newKey) {
        return (path, value) -> {
            Object[] arr = path.array();
            if (arr.length == 0) {
                throw new ConfigurateException(value, "The root node cannot be renamed!");
            }
            arr[arr.length - 1] = newKey;
            return arr;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type, @Nullable V value) {
        return (path, node) -> {
            node.set(type, value);
            return null;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type, Supplier<@Nullable V> valueSupplier) {
        return (path, value) -> {
            value.set(type, valueSupplier.get());
            return null;
        };
    }

    public static <V> TransformAction set(Class<V> type, Supplier<V> valueSupplier) {
        return (path, value) -> {
            value.set(type, valueSupplier.get());
            return null;
        };
    }

    public Object @Nullable [] visitPath(NodePath var1, ConfigurationNode var2) throws ConfigurateException;
}

