/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.relocated.adventure.minimessage.MiniMessage;
import dev.qixils.relocated.adventure.minimessage.tag.Tag;
import dev.qixils.relocated.adventure.minimessage.tag.resolver.TagResolver;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.renderer.TranslatableComponentRenderer;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KyoriTranslator
extends TranslatableComponentRenderer<Locale>
implements TranslationRegistry {
    private static final Logger logger = LoggerFactory.getLogger("CrowdControl/KyoriTranslator");
    private final String prefix;
    private final TranslationRegistry translator;
    private final ClassLoader pluginClassLoader;

    @Nullable
    private static URL loadFirst(String path, ClassLoader ... classLoaders) {
        for (ClassLoader classLoader : classLoaders) {
            URL url = classLoader.getResource(path);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private List<String> listResourcesIn(Plugin<?, ?> plugin, String path) throws Exception {
        List<String> list;
        URL url = KyoriTranslator.loadFirst(path, this.pluginClassLoader, ClassLoader.getSystemClassLoader());
        if (url == null) {
            return Collections.emptyList();
        }
        String urlPath = url.getPath();
        if (url.getProtocol().equals("file")) {
            List<String> list2;
            block26: {
                Stream<Path> paths2 = Files.list(Paths.get(new URI(urlPath)));
                try {
                    list2 = paths2.map(file -> file.getFileName().toString()).collect(Collectors.toList());
                    if (paths2 == null) break block26;
                }
                catch (Throwable throwable) {
                    try {
                        if (paths2 != null) {
                            try {
                                paths2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception paths2) {
                        // empty catch block
                    }
                }
                paths2.close();
            }
            return list2;
        }
        int idx2 = urlPath.indexOf("!");
        File jarUrl = idx2 == -1 ? new File(((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI()) : new File(urlPath.substring("file:".length(), urlPath.indexOf("!")));
        JarFile jar = new JarFile(jarUrl);
        try {
            list = Collections.list(jar.entries()).stream().filter(entry -> entry.getName().startsWith(path)).map(entry -> entry.getName().substring(path.length())).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            catch (Exception idx2) {
                List<String> list3;
                block27: {
                    Path folder = plugin.getPath(path);
                    if (folder == null) {
                        throw new RuntimeException();
                    }
                    Stream<Path> paths = Files.list(folder);
                    try {
                        list3 = paths.map(file -> file.getFileName().toString()).collect(Collectors.toList());
                        if (paths == null) break block27;
                    }
                    catch (Throwable throwable4) {
                        try {
                            if (paths != null) {
                                try {
                                    paths.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                            }
                            throw throwable4;
                        }
                        catch (Exception exception) {
                            return Collections.emptyList();
                        }
                    }
                    paths.close();
                }
                return list3;
            }
        }
        jar.close();
        return list;
    }

    public KyoriTranslator(@NotNull String modId, @NotNull String prefix, @NotNull Plugin<?, ?> plugin, Locale ... locales) {
        this.prefix = prefix;
        this.pluginClassLoader = plugin.getClass().getClassLoader();
        Pattern filePattern = Pattern.compile(Pattern.quote(prefix) + "_(?<languageTag>\\w{2}(?:_\\w+)*)\\.properties");
        logger.debug("Registering translator");
        Key name = Key.key((String)modId, (String)"translations");
        this.translator = TranslationRegistry.create((Key)name);
        this.translator.defaultLocale(Objects.requireNonNull(Translator.parseLocale((String)"en_US")));
        boolean loaded = false;
        try {
            List<String> filenames = this.listResourcesIn(plugin, "i18n/");
            if (!filenames.isEmpty()) {
                for (String filename : filenames) {
                    Matcher matcher = filePattern.matcher(filename);
                    if (!matcher.find()) continue;
                    String languageTag = matcher.group("languageTag").replace('_', '-');
                    Locale locale = Locale.forLanguageTag(languageTag);
                    this.register(locale);
                    loaded = true;
                }
                logger.info("Loaded locales dynamically");
            }
        }
        catch (Exception e) {
            loaded = false;
            logger.warn("Failed to load locales dynamically", e);
        }
        if (!loaded) {
            logger.info("Manually loading locales");
            for (Locale locale : locales) {
                this.register(locale);
            }
        }
    }

    @NotNull
    public Key name() {
        return this.translator.name();
    }

    public boolean contains(@NotNull String key) {
        return this.translator.contains(key);
    }

    public void defaultLocale(@NotNull Locale locale) {
        this.translator.defaultLocale(locale);
    }

    public void register(@NotNull String key, @NotNull Locale locale, @NotNull MessageFormat format) {
        this.translator.register(key, locale, format);
    }

    public void unregister(@NotNull String key) {
        this.translator.unregister(key);
    }

    private void register(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n." + this.prefix, locale, this.pluginClassLoader);
        this.translator.registerAll(locale, bundle, false);
        logger.info("Registered locale " + String.valueOf(locale));
    }

    @Nullable
    public Component translate(@NotNull TranslatableComponent component, @NotNull Locale context) {
        if (this.translate(component.key(), context) == null) {
            return null;
        }
        return this.renderTranslatable(component, context);
    }

    @Nullable
    public MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        logger.debug("Plainly translating " + key + " for " + String.valueOf(locale));
        return this.translator.translate(key, locale);
    }

    @NotNull
    protected Component renderTranslatable(@NotNull TranslatableComponent component, @NotNull Locale context) {
        logger.debug("Richly translating " + component.key() + " for " + String.valueOf(context));
        @Nullable MessageFormat format = this.translate(component.key(), context);
        if (format == null) {
            return GlobalTranslator.renderer().render((Component)component, (Object)context);
        }
        TextComponent.Builder builder = Component.text();
        this.mergeStyle((Component)component, (ComponentBuilder)builder, context);
        List args = component.args();
        if (args.isEmpty()) {
            builder.append(MiniMessage.miniMessage().deserialize(format.format(null, new StringBuffer(), null).toString()));
        } else {
            TagResolver.Builder resolver = TagResolver.builder();
            for (int i = 0; i < args.size(); ++i) {
                resolver.tag(String.valueOf(i), Tag.selfClosingInserting(this.render((Component)args.get(i), context)));
            }
            builder.append(MiniMessage.miniMessage().deserialize(format.format(null, new StringBuffer(), null).toString(), resolver.build()));
        }
        return this.optionallyRenderChildrenAppendAndBuild(component.children(), (ComponentBuilder)builder, context);
    }
}

