/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.command.impl.health;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.command.Command;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.relocated.annotations.NotNull;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;

public class FullHealCommand<P>
implements Command<P> {
    @NotNull
    private final String effectName = "full_heal";
    @NotNull
    private final Plugin<P, ?> plugin;

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull P>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isActive(ccPlayer, "health_modifier")) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot heal players under the effects of health modifiers");
            }
            List players = (List)playerSupplier.get();
            boolean success = false;
            for (Object rawPlayer : players) {
                MCCCPlayer player = this.plugin.getPlayer(rawPlayer);
                double maxHealth = player.maxHealth();
                if (!(player.health() < maxHealth)) continue;
                this.sync(() -> player.health(maxHealth));
                success = true;
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "All players are at maximum health");
        }));
    }

    @Generated
    public FullHealCommand(@NotNull Plugin<P, ?> plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    @Override
    @NotNull
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @NotNull
    @Generated
    public Plugin<P, ?> getPlugin() {
        return this.plugin;
    }
}

