/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric;

import dev.qixils.crowdcontrol.TriState;
import dev.qixils.crowdcontrol.common.EntityMapper;
import dev.qixils.crowdcontrol.common.PlayerEntityMapper;
import dev.qixils.crowdcontrol.common.PlayerManager;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.mc.MCCCPlayer;
import dev.qixils.crowdcontrol.common.packets.util.ExtraFeature;
import dev.qixils.crowdcontrol.common.util.SemVer;
import dev.qixils.crowdcontrol.plugin.configurate.ConfiguratePlugin;
import dev.qixils.crowdcontrol.plugin.fabric.CommandRegister;
import dev.qixils.crowdcontrol.plugin.fabric.CommandSourceStackMapper;
import dev.qixils.crowdcontrol.plugin.fabric.MinecraftEvents;
import dev.qixils.crowdcontrol.plugin.fabric.MojmapPlayerManager;
import dev.qixils.crowdcontrol.plugin.fabric.ServerPlayerMapper;
import dev.qixils.crowdcontrol.plugin.fabric.SoftLockResolver;
import dev.qixils.crowdcontrol.plugin.fabric.event.EventManager;
import dev.qixils.crowdcontrol.plugin.fabric.event.Join;
import dev.qixils.crowdcontrol.plugin.fabric.event.Leave;
import dev.qixils.crowdcontrol.plugin.fabric.mc.FabricPlayer;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ExtraFeatureC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.RequestVersionS2C;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ResponseVersionC2S;
import dev.qixils.crowdcontrol.plugin.fabric.packets.ServerPacketContext;
import dev.qixils.crowdcontrol.plugin.fabric.utils.ClientAdapter;
import dev.qixils.crowdcontrol.plugin.fabric.utils.MojmapTextUtil;
import dev.qixils.crowdcontrol.plugin.fabric.utils.PermissionUtil;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import dev.qixils.relocated.checkerframework.checker.nullness.qual.MonotonicNonNull;
import dev.qixils.relocated.configurate.hocon.HoconConfigurationLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.text.Component;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7695;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ModdedCrowdControlPlugin
extends ConfiguratePlugin<class_3222, class_2168> {
    public static boolean CLIENT_INITIALIZED = false;
    public static boolean CLIENT_AVAILABLE = false;
    @NotNull
    private final EventManager eventManager = new EventManager();
    private final CommandRegister commandRegister = new CommandRegister(this);
    @Nullable
    protected MinecraftServer server;
    @Nullable
    protected MinecraftServerAudiences adventure;
    @NotNull
    private MojmapTextUtil textUtil = new MojmapTextUtil(this);
    @NotNull
    private Executor syncExecutor = runnable -> {
        try {
            if (this.server != null) {
                this.server.method_40000(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            this.getSLF4JLogger().error("Error while executing sync task", e);
        }
    };
    private final ExecutorService asyncExecutor = Executors.newCachedThreadPool();
    private final Logger SLF4JLogger = LoggerFactory.getLogger("CrowdControl");
    private final PlayerManager<class_3222> playerManager = new MojmapPlayerManager(this);
    private final PlayerEntityMapper<class_3222> playerMapper = new ServerPlayerMapper(this);
    private final EntityMapper<class_2168> commandSenderMapper = new CommandSourceStackMapper(this);
    private final SoftLockResolver softLockResolver = new SoftLockResolver(this);
    @NotNull
    private final HoconConfigurationLoader configLoader = this.createConfigLoader(Path.of("config", new String[0]));
    private static @MonotonicNonNull ModdedCrowdControlPlugin instance;
    private boolean paused = false;

    public ModdedCrowdControlPlugin() {
        super(class_3222.class, class_2168.class);
        CommandConstants.SOUND_VALIDATOR = key -> class_7923.field_41172.method_10250(class_2960.method_60655((String)key.namespace(), (String)key.value()));
        instance = this;
        this.getEventManager().registerListeners(this.softLockResolver);
        this.getEventManager().register(Join.class, join -> this.onPlayerJoin(join.player()));
        this.getEventManager().register(Leave.class, leave -> this.onPlayerLeave(leave.player()));
    }

    public void onInitialize() {
        this.getSLF4JLogger().debug("Initializing");
        this.registerChatCommands();
        MinecraftEvents.SERVER_STARTING.register(newServer -> {
            this.getSLF4JLogger().debug("Server starting");
            this.setServer((MinecraftServer)newServer);
        });
        MinecraftEvents.SERVER_STOPPING.register($ -> this.shutdown());
        MinecraftEvents.SERVER_STOPPED.register(newServer -> {
            this.getSLF4JLogger().debug("Server stopping");
            this.setServer(null);
        });
    }

    public <T> class_2378<T> registry(class_5321<? extends class_2378<? extends T>> key, @Nullable class_5455 accessor) {
        if (accessor == null) {
            accessor = this.server().method_30611();
        }
        return accessor.method_30530(key);
    }

    public <T> Iterable<class_6880.class_6883<T>> registryHolders(class_5321<? extends class_2378<? extends T>> key, @Nullable class_5455 accessor) {
        final class_2378<T> registry = this.registry(key, accessor);
        return new Iterable<class_6880.class_6883<T>>(this){

            @Override
            @NotNull
            public Iterator<class_6880.class_6883<T>> iterator() {
                return registry.method_42017().iterator();
            }
        };
    }

    @Override
    @NotNull
    public MCCCPlayer getPlayer(@NotNull class_3222 player) {
        return new FabricPlayer(player);
    }

    @NotNull
    public static ModdedCrowdControlPlugin getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Plugin instance not initialized");
        }
        return instance;
    }

    public static boolean isInstanceAvailable() {
        return instance != null;
    }

    @Override
    @NotNull
    public Collection<String> getHosts() {
        HashSet<String> hosts = new HashSet<String>(super.getHosts());
        ClientAdapter.getLocalPlayerId().map(UUID::toString).ifPresent(hosts::add);
        return hosts;
    }

    @NotNull
    public MinecraftServer server() throws IllegalStateException {
        if (this.server == null) {
            throw new IllegalStateException("Tried to access server without one running");
        }
        return this.server;
    }

    @NotNull
    public MinecraftServerAudiences adventure() throws IllegalStateException {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure without running a server");
        }
        return this.adventure;
    }

    @NotNull
    public Optional<MinecraftServerAudiences> adventureOptional() {
        return Optional.ofNullable(this.adventure);
    }

    protected void setServer(@Nullable MinecraftServer server) {
        if (server == null) {
            this.server = null;
            this.adventure = null;
            this.syncExecutor = Runnable::run;
        } else {
            this.server = server;
            this.adventure = MinecraftServerAudiences.of((MinecraftServer)server);
            this.syncExecutor = server;
            this.textUtil = new MojmapTextUtil(this);
            this.initCrowdControl();
        }
    }

    @Override
    public CompletableFuture<?> shutdown() {
        CompletableFuture<?> superShutdown = super.shutdown();
        this.asyncExecutor.shutdown();
        return CompletableFuture.allOf(superShutdown, CompletableFuture.supplyAsync(() -> {
            try {
                return this.asyncExecutor.awaitTermination(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    @Override
    @NotNull
    public Audience getConsole() {
        return this.adventure().console();
    }

    @Override
    public void onPlayerJoin(class_3222 player) {
        ClientAdapter.getLocalPlayerId().ifPresent(uuid -> this.clientVersions.put(uuid, SemVer.MOD));
        if (!this.clientVersions.containsKey(player.method_5667())) {
            this.getSLF4JLogger().debug("Sending version request to {}", (Object)player.method_5667());
            this.sendToPlayer(player, RequestVersionS2C.INSTANCE);
        }
        super.onPlayerJoin(player);
    }

    @Override
    @Nullable
    public class_3222 asPlayer(@NotNull class_2168 sender) {
        return sender.method_44023();
    }

    @NotNull
    public TriState isEnabled(class_7695 feature) {
        if (this.server == null) {
            return TriState.UNKNOWN;
        }
        return TriState.fromBoolean(feature.method_45382(this.server.method_27728().method_45560()));
    }

    public boolean isDisabled(class_7695 feature) {
        return this.isEnabled(feature) == TriState.FALSE;
    }

    @NotNull
    public Component toAdventure(class_2561 vanilla) {
        return this.adventure().asAdventure(vanilla);
    }

    @NotNull
    public Component toAdventure(Component text, @NotNull Pointered viewer) {
        return this.adventure().renderer().render(text, (Object)viewer);
    }

    @NotNull
    public Component toAdventure(class_2561 vanilla, @NotNull Pointered viewer) {
        return this.toAdventure(this.toAdventure(vanilla), viewer);
    }

    @NotNull
    public class_2561 toNative(Component text, @NotNull Pointered viewer) {
        return this.adventure().asNative(this.toAdventure(text, viewer));
    }

    public abstract PermissionUtil getPermissionUtil();

    @NotNull
    public Stream<class_3222> toPlayerStream(@Nullable Collection<UUID> uuids) {
        MinecraftServer _server = this.server;
        if (uuids == null || _server == null) {
            return Stream.empty();
        }
        return uuids.stream().map(id -> _server.method_3760().method_14602(id)).filter(Objects::nonNull);
    }

    @NotNull
    public List<class_3222> toPlayerList(@Nullable Collection<UUID> uuids) {
        return this.toPlayerStream(uuids).toList();
    }

    public void handleVersionResponse(ResponseVersionC2S payload, ServerPacketContext context) {
        UUID uuid = context.player().method_5667();
        SemVer version = payload.version();
        this.getSLF4JLogger().info("Received version {} from client {}", (Object)version, (Object)uuid);
        this.clientVersions.put(uuid, version);
        this.updateConditionalEffectVisibility(uuid);
    }

    public void handleExtraFeatures(ExtraFeatureC2S payload, ServerPacketContext context) {
        UUID uuid = context.player().method_5667();
        Set<ExtraFeature> features = payload.features();
        this.getSLF4JLogger().info("Received features {} from client {}", (Object)features, (Object)uuid);
        this.extraFeatures.put(uuid, features);
        this.updateConditionalEffectVisibility(uuid);
    }

    public abstract void sendToPlayer(@NotNull class_3222 var1, @NotNull class_8710 var2);

    public static void sendToPlayerStatic(@NotNull class_3222 player, @NotNull class_8710 payload) {
        if (!ModdedCrowdControlPlugin.isInstanceAvailable()) {
            return;
        }
        ModdedCrowdControlPlugin.getInstance().sendToPlayer(player, payload);
    }

    @NotNull
    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public CommandRegister commandRegister() {
        return this.commandRegister;
    }

    @Nullable
    @Generated
    public MinecraftServer getServer() {
        return this.server;
    }

    @Override
    @NotNull
    @Generated
    public MojmapTextUtil getTextUtil() {
        return this.textUtil;
    }

    @Override
    @NotNull
    @Generated
    public Executor getSyncExecutor() {
        return this.syncExecutor;
    }

    @Override
    @Generated
    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    @Override
    @Generated
    public Logger getSLF4JLogger() {
        return this.SLF4JLogger;
    }

    @Override
    @Generated
    public PlayerManager<class_3222> getPlayerManager() {
        return this.playerManager;
    }

    @Override
    @Generated
    public PlayerEntityMapper<class_3222> playerMapper() {
        return this.playerMapper;
    }

    @Override
    @Generated
    public EntityMapper<class_2168> commandSenderMapper() {
        return this.commandSenderMapper;
    }

    @Generated
    public SoftLockResolver getSoftLockResolver() {
        return this.softLockResolver;
    }

    @NotNull
    @Generated
    public HoconConfigurationLoader getConfigLoader() {
        return this.configLoader;
    }

    @Override
    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

