/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.relocated.annotations.NotNull;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class EntityChaosCommand
extends ModdedCommand {
    private static final int R = 400;
    private final String effectName = "entity_chaos";

    public EntityChaosCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            HashSet<class_1297> entities = new HashSet<class_1297>(200);
            if (players.stream().anyMatch(this.plugin::globalEffectsUsableFor)) {
                for (class_3218 level : this.plugin.server().method_3738()) {
                    for (class_1297 entity : level.method_27909()) {
                        if (entity.method_5864() == class_1299.field_6097) continue;
                        entities.add(entity);
                    }
                }
            } else {
                for (class_3222 player : (List)playerSupplier.get()) {
                    class_243 pp = player.method_73189();
                    for (class_1297 entity : player.method_51469().method_27909()) {
                        if (entity.method_5864() == class_1299.field_6097) continue;
                        class_243 ep = entity.method_73189();
                        double x = pp.field_1352 - ep.field_1352;
                        double y = pp.field_1351 - ep.field_1351;
                        double z = pp.field_1350 - ep.field_1350;
                        if (!(x * x + y * y + z * z < 400.0)) continue;
                        entities.add(entity);
                    }
                }
            }
            if (entities.size() < 10) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Not enough entities found to teleport");
            }
            int i = 0;
            boolean success = false;
            for (class_1297 entity : entities) {
                try {
                    entity.method_5772();
                    class_3222 target = (class_3222)players.get(i++ % players.size());
                    class_243 dest = target.method_73189();
                    success |= entity.method_48105(target.method_51469(), dest.field_1352, dest.field_1351, dest.field_1350, Collections.emptySet(), entity.method_36454(), entity.method_36455(), false);
                }
                catch (Exception exception) {}
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not teleport entities");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }
}

