/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.utils.Location;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.class_1297;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

abstract class NearbyLocationCommand<S>
extends ModdedCommand {
    private final List<String> effectGroups = List.of("walk", "look");

    protected NearbyLocationCommand(ModdedCrowdControlPlugin plugin) {
        super(plugin);
    }

    @Nullable
    private static Location highestLocation(@Nullable Location origin) {
        if (origin == null) {
            return null;
        }
        int air = 0;
        class_3218 world = origin.level();
        Location location = new Location(world, origin.x(), world.method_32819() - 1, origin.z(), origin.yaw(), origin.pitch());
        while (true) {
            class_2680 block = location.block();
            if (location.y() < (double)(world.method_31607() + 1)) {
                return null;
            }
            if (block.method_26204().method_9538(block) && !block.method_51366()) {
                ++air;
            } else {
                if (air >= 1) break;
                air = 0;
            }
            location = location.add(0.0, -1.0, 0.0);
        }
        return location;
    }

    @Nullable
    private static Location safeLocation(@Nullable Location origin) {
        Location location = NearbyLocationCommand.highestLocation(origin);
        if (location == null) {
            return null;
        }
        class_2680 block = location.block();
        class_2248 type = block.method_26204();
        if (class_2246.field_10036.equals(type)) {
            location.block(class_2246.field_10124.method_9564());
        } else if (!block.method_51366()) {
            location.block(class_2246.field_10033.method_9564());
        }
        location = location.add(0.5, 1.0, 0.5);
        return location;
    }

    @Nullable
    protected abstract Location search(@NotNull Location var1, @NotNull S var2);

    @NotNull
    protected abstract Collection<S> getSearchTypes(@NotNull class_3218 var1);

    @NotNull
    protected abstract Component nameOf(@NotNull S var1);

    @Nullable
    protected S currentType(@NotNull Location origin) {
        return null;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            if (this.isArrayActive(ccPlayer)) {
                return new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Cannot teleport while frozen");
            }
            boolean success = false;
            block0: for (class_3222 player : (List)playerSupplier.get()) {
                class_3218 world = player.method_51469();
                Location location = new Location((class_1297)player);
                S currentType = this.currentType(location);
                ArrayList<S> searchTypes = new ArrayList<S>(this.getSearchTypes(world));
                Collections.shuffle(searchTypes, random);
                for (Object searchType : searchTypes) {
                    Location target;
                    if (searchType.equals(currentType) || (target = this.search(location, searchType)) == null) continue;
                    Location destination = NearbyLocationCommand.safeLocation(target);
                    if (destination == null) {
                        this.plugin.getSLF4JLogger().debug("Skipping {} because it is not safe", searchType);
                        continue;
                    }
                    if (class_3532.method_41189((double)(destination.x() - location.x()), (double)(destination.z() - location.z())) <= 2500.0 || !world.method_8621().method_35317(destination.x(), destination.z())) continue;
                    player.method_5859(destination.x(), destination.y(), destination.z());
                    player.sendActionBar((Component)Component.translatable((String)"cc.effect.nearby_location.output", (ComponentLike[])new ComponentLike[]{this.nameOf(searchType).color((TextColor)NamedTextColor.YELLOW)}));
                    success = true;
                    continue block0;
                }
            }
            return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "Could not find a location to teleport to");
        }, this.plugin.getSyncExecutor()));
    }

    @Override
    @Generated
    public List<String> getEffectGroups() {
        return this.effectGroups;
    }
}

