/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.plugin.fabric.commands;

import dev.qixils.crowdcontrol.common.LimitConfig;
import dev.qixils.crowdcontrol.common.command.CommandConstants;
import dev.qixils.crowdcontrol.common.util.ThreadUtil;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCommand;
import dev.qixils.crowdcontrol.plugin.fabric.ModdedCrowdControlPlugin;
import dev.qixils.crowdcontrol.plugin.fabric.commands.EntityCommand;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import live.crowdcontrol.cc4j.CCPlayer;
import live.crowdcontrol.cc4j.websocket.data.CCEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.CCInstantEffectResponse;
import live.crowdcontrol.cc4j.websocket.data.ResponseStatus;
import live.crowdcontrol.cc4j.websocket.payload.PublicEffectPayload;
import lombok.Generated;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class RemoveEntityCommand<E extends class_1297>
extends ModdedCommand
implements EntityCommand<E> {
    protected final class_1299<? extends E> entityType;
    protected final List<class_1299<? extends E>> entityTypes;
    private final String effectName;
    private final Component displayName;
    private final String image = "remove_entity_creeper";
    private final int price = 250;
    private final byte priority = (byte)-5;
    private final List<String> categories = Collections.singletonList("Remove Entity");

    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, class_1299<E> entityType) {
        this(plugin, "remove_entity_" + CommandConstants.csIdOf((Keyed)class_7923.field_41177.method_10221(entityType)), (Component)Component.translatable((String)"cc.effect.remove_entity.name", (ComponentLike[])new ComponentLike[]{plugin.toAdventure(entityType.method_5897())}), entityType, new class_1299[0]);
    }

    @SafeVarargs
    public RemoveEntityCommand(ModdedCrowdControlPlugin plugin, String effectName, @Nullable Component displayName, class_1299<? extends E> firstEntity, class_1299<? extends E> ... otherEntities) {
        super(plugin);
        this.entityType = firstEntity;
        this.entityTypes = new ArrayList<class_1299<? extends E>>(1 + otherEntities.length);
        this.entityTypes.add(firstEntity);
        this.entityTypes.addAll(Arrays.asList(otherEntities));
        this.effectName = effectName;
        this.displayName = displayName;
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    @Override
    public boolean isMonster() {
        if (this.entityType == class_1299.field_6116) {
            return false;
        }
        return EntityCommand.super.isMonster();
    }

    private boolean removeEntityFrom(class_3222 player) {
        class_3218 level = player.method_51469();
        if (this.entityType == class_1299.field_6116 && level.method_29198() != null) {
            return false;
        }
        class_243 playerPosition = player.method_73189();
        List<class_1297> entities = StreamSupport.stream(level.method_27909().spliterator(), false).filter(entity -> this.getEntityTypes().contains(entity.method_5864()) && entity.method_5707(playerPosition) <= 1225.0).sorted((entity1, entity2) -> (int)(entity1.method_5707(playerPosition) - entity2.method_5707(playerPosition))).toList();
        if (entities.isEmpty()) {
            return false;
        }
        entities.getFirst().method_5650(class_1297.class_5529.field_26998);
        return true;
    }

    @Override
    public void execute(@NotNull @NotNull Supplier<@NotNull List<@NotNull class_3222>> playerSupplier, @NotNull PublicEffectPayload request, @NotNull CCPlayer ccPlayer) {
        ccPlayer.sendResponse(ThreadUtil.waitForSuccess(request, () -> {
            List players = (List)playerSupplier.get();
            LimitConfig config = this.getPlugin().getLimitConfig();
            int playerLimit = config.getEntityLimit(class_7923.field_41177.method_10221(this.entityType).method_12832());
            CCEffectResponse tryExecute = this.tryExecute(players, request, ccPlayer);
            if (tryExecute != null) {
                return tryExecute;
            }
            return this.executeLimit(request, players, playerLimit, player -> CompletableFuture.supplyAsync(() -> {
                boolean success = false;
                try {
                    success = this.removeEntityFrom((class_3222)player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return success ? new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.SUCCESS) : new CCInstantEffectResponse(request.getRequestId(), ResponseStatus.FAIL_TEMPORARY, "No " + this.plugin.getTextUtil().asPlain(this.entityType.method_5897()) + "s found nearby to remove");
            }, this.getPlugin().getSyncExecutor()).join());
        }));
    }

    @Override
    @Generated
    public class_1299<? extends E> getEntityType() {
        return this.entityType;
    }

    @Generated
    public List<class_1299<? extends E>> getEntityTypes() {
        return this.entityTypes;
    }

    @Override
    @Generated
    public String getEffectName() {
        return this.effectName;
    }

    @Override
    @Generated
    public String getImage() {
        return this.image;
    }

    @Override
    @Generated
    public int getPrice() {
        return this.price;
    }

    @Override
    @Generated
    public byte getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public List<String> getCategories() {
        return this.categories;
    }
}

