/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.qixils.relocated.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import live.crowdcontrol.cc4j.websocket.data.CallDataMethod;

public class CallData<A> {
    @NotNull
    protected final String type;
    @NotNull
    protected final UUID id;
    @NotNull
    protected final String method;
    @NotNull
    protected final @NotNull List<@NotNull A> args;

    @JsonCreator
    CallData(@JsonProperty(value="type") @NotNull String type, @JsonProperty(value="id") @NotNull UUID id, @JsonProperty(value="method") @NotNull String method, @JsonProperty(value="args") @NotNull List<A> args) {
        this.type = type;
        this.id = id;
        this.method = method;
        this.args = Collections.unmodifiableList(new ArrayList<A>(args));
    }

    public CallData(@NotNull CallDataMethod<A> method, @NotNull List<A> args) {
        this.type = "call";
        this.id = UUID.randomUUID();
        this.method = method.getValue();
        this.args = Collections.unmodifiableList(new ArrayList<A>(args));
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public UUID getId() {
        return this.id;
    }

    @NotNull
    public String getMethod() {
        return this.method;
    }

    @NotNull
    public @NotNull List<@NotNull A> getArgs() {
        return this.args;
    }
}

