/*
 * Decompiled with CFR 0.152.
 */
package live.crowdcontrol.cc4j.websocket.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.qixils.relocated.annotations.NotNull;
import dev.qixils.relocated.annotations.alt.Pattern;
import dev.qixils.relocated.annotations.alt.RegExp;
import dev.qixils.relocated.annotations.alt.Subst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginData {
    @RegExp
    @NotNull
    public static final String CODE_PATTERN = "^[BCDFGHJKLMNPQRTW6789]{6}$";
    @NotNull
    private static final Logger log = LoggerFactory.getLogger("CrowdControl/LoginData");
    @NotNull
    private final String appID;
    @Pattern(value="^[BCDFGHJKLMNPQRTW6789]{6}$")
    @Subst(value="BCDFGH")
    @NotNull
    private final String code;

    @JsonCreator
    public LoginData(@JsonProperty(value="appID") @NotNull String appID, @JsonProperty(value="code") @Pattern(value="^[BCDFGHJKLMNPQRTW6789]{6}$") @Subst(value="BCDFGH") @NotNull String code) {
        if (!code.matches(CODE_PATTERN)) {
            log.warn("Code {} may be invalid; fails to match expected pattern", (Object)code);
        }
        this.appID = appID;
        this.code = code;
    }

    @NotNull
    public String getAppID() {
        return this.appID;
    }

    @Pattern(value="^[BCDFGHJKLMNPQRTW6789]{6}$")
    @NotNull
    public String getCode() {
        return this.code;
    }
}

