/*
 * Decompiled with CFR 0.152.
 */
package dev.qixils.crowdcontrol.common.packets;

import dev.qixils.crowdcontrol.common.Plugin;
import dev.qixils.crowdcontrol.common.components.MovementStatusType;
import dev.qixils.crowdcontrol.common.components.MovementStatusValue;
import dev.qixils.crowdcontrol.common.packets.PluginPacket;
import dev.qixils.crowdcontrol.common.packets.util.Utf8String;
import dev.qixils.relocated.annotations.Nullable;
import io.netty.buffer.ByteBuf;
import java.util.Optional;

public class MovementStatusPacketS2C
implements PluginPacket {
    public static final PluginPacket.Metadata<MovementStatusPacketS2C> METADATA = new PluginPacket.Metadata<MovementStatusPacketS2C>(Plugin.MOVEMENT_STATUS_KEY.asString(), MovementStatusPacketS2C::new);
    protected static final int SIZE = 20;
    @Nullable
    private final MovementStatusType statusType;
    @Nullable
    private final MovementStatusValue statusValue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MovementStatusPacketS2C(ByteBuf buf) {
        MovementStatusType _type = null;
        MovementStatusValue _value = null;
        try {
            _type = MovementStatusType.valueOf(Utf8String.read(buf, 20));
            _value = MovementStatusValue.valueOf(Utf8String.read(buf, 20));
        }
        catch (Exception ignored) {
            LOGGER.warn("Unknown type/value for MovementStatus ({}, {})", (Object)_type, (Object)_value);
        }
        finally {
            this.statusType = _type;
            this.statusValue = _value;
        }
    }

    @Override
    public void write(ByteBuf buf) {
        Utf8String.write(buf, Optional.ofNullable(this.statusType).map(Enum::name).orElse(""), 20);
        Utf8String.write(buf, Optional.ofNullable(this.statusValue).map(Enum::name).orElse(""), 20);
    }

    @Override
    public PluginPacket.Metadata<?> metadata() {
        return METADATA;
    }

    @Nullable
    public MovementStatusType statusType() {
        return this.statusType;
    }

    @Nullable
    public MovementStatusValue statusValue() {
        return this.statusValue;
    }

    public MovementStatusPacketS2C(@Nullable MovementStatusType statusType, @Nullable MovementStatusValue statusValue) {
        this.statusType = statusType;
        this.statusValue = statusValue;
    }
}

